<?php

namespace backend\modules\contentPhoto\models;

use Yii;

/**
 * This is the model class for table "content_photo_list".
 *
 * @property int $photo_id
 * @property int|null $photo_main
 * @property int|null $photo_parent_id
 * @property string|null $photo_language
 * @property int|null $photo_sort
 * @property string|null $photo_url
 * @property string|null $photo_descr
 * @property string|null $created_at
 * @property string|null $created_by
 * @property string|null $updated_at
 * @property string|null $updated_by
 */
class ContentPhotoList extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_photo_list';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['photo_language', 'photo_descr', 'photo_sort'], 'required'],
            [['photo_url'], 'required', 'on' => 'create'],
            [['photo_main', 'photo_parent_id', 'photo_sort'], 'integer'],
            [['photo_descr'], 'string'],
            [['created_at', 'updated_at', 'photo_gallery_id', 'photo_language', 'photo_url', 'created_by', 'updated_by'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'photo_id' => Yii::t('app', 'Photo ID'),
            'photo_main' => Yii::t('app', 'Photo Main'),
            'photo_parent_id' => Yii::t('app', 'Photo Parent ID'),
            'photo_language' => Yii::t('app', 'Language'),
            'photo_sort' => Yii::t('app', 'Sorting'),
            'photo_url' => Yii::t('app', 'Photo'),
            'photo_descr' => Yii::t('app', 'Description'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
