<?php

namespace backend\modules\contentPhoto\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentPhoto\models\ContentPhotoGallery;
use Yii;

/**
 * ContentPhotoGallerySearch represents the model behind the search form of `backend\modules\contentPhoto\models\ContentPhotoGallery`.
 */
class ContentPhotoGallerySearch extends ContentPhotoGallery {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['gallery_id', 'gallery_main', 'gallery_parent_id'], 'integer'],
            [['gallery_language', 'gallery_title', 'gallery_descr', 'gallery_date', 'gallery_location', 'gallery_status', 'gallery_portal',
            'gallery_thumbnail', 'created_at', 'created_by', 'updated_at', 'updated_by', 'gallery_cat', 'gallery_code'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentPhotoGallery::find();

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions

        $query->andFilterWhere(['like', 'gallery_title', $this->gallery_title])
                ->andFilterWhere(['like', 'gallery_date', $this->gallery_date])
                ->andFilterWhere(['like', 'gallery_location', $this->gallery_location])
                ->andFilterWhere(['like', 'gallery_code', $this->gallery_code])
                ->andFilterWhere(['=', 'gallery_cat', $this->gallery_cat])
                ->andFilterWhere(['=', 'gallery_status', $this->gallery_status])
                ->andFilterWhere(['=', 'gallery_portal', $this->gallery_portal]);

        $query->andWhere(['=', 'gallery_main', '1']);

        return $dataProvider;
    }

}
