<?php

namespace backend\modules\contentPhoto\models;

use Yii;

/**
 * This is the model class for table "content_photo_gallery".
 *
 * @property int $gallery_id
 * @property int|null $gallery_main
 * @property int|null $gallery_parent_id
 * @property string|null $gallery_language
 * @property string|null $gallery_title
 * @property string|null $gallery_descr
 * @property string|null $gallery_date
 * @property string|null $gallery_location
 * @property string|null $gallery_status
 * @property string|null $gallery_portal
 * @property string|null $gallery_thumbnail
 * @property string|null $created_at
 * @property string|null $created_by
 * @property string|null $updated_at
 * @property string|null $updated_by
 */
class ContentPhotoGallery extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_photo_gallery';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['gallery_language', 'gallery_title', 'gallery_descr', 'gallery_date', 'gallery_location', 'gallery_status', 'gallery_portal', 'gallery_cat', 'gallery_code'], 'required'],
            [['gallery_main', 'gallery_parent_id'], 'integer'],
            [['gallery_descr'], 'string'],
            [['created_at', 'updated_at', 'gallery_language', 'gallery_title', 'gallery_date', 'gallery_location', 'gallery_status', 'gallery_portal', 'gallery_thumbnail', 'created_by', 'updated_by'], 'safe'],
            [['gallery_thumbnail'], 'required', 'on' => 'create'],
            [['gallery_code'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'gallery_id' => Yii::t('app', 'Gallery ID'),
            'gallery_main' => Yii::t('app', 'Gallery Main'),
            'gallery_parent_id' => Yii::t('app', 'Gallery Parent ID'),
            'gallery_language' => Yii::t('app', 'Language'),
            'gallery_title' => Yii::t('app', 'Title'),
            'gallery_descr' => Yii::t('app', 'Description'),
            'gallery_date' => Yii::t('app', 'Date'),
            'gallery_location' => Yii::t('app', 'Location'),
            'gallery_status' => Yii::t('app', 'Status'),
            'gallery_portal' => Yii::t('app', 'Portal'),
            'gallery_thumbnail' => Yii::t('app', 'Thumbnail'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'gallery_cat' => Yii::t('app', 'Category'),
            'gallery_code' => Yii::t('app', 'Page Slug'),
        ];
    }

}
