<?php

namespace backend\modules\contentPhoto\controllers;

use Yii;
use backend\modules\contentPhoto\models\ContentPhotoList;
use backend\modules\contentPhoto\models\ContentPhotoListSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
/**
 * ContentPhotoListController implements the CRUD actions for ContentPhotoList model.
 */
class ContentPhotoListController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentPhotoList models.
     * @return mixed
     */
    public function actionIndex($gallery_id) {
        $searchModel = new ContentPhotoListSearch();
        $searchModel->photo_gallery_id = $gallery_id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentPhotoList model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentPhotoList model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($gallery_id) {
        $model = new ContentPhotoList();
        $model->scenario = 'create';
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->photo_main = 1;
        $model->photo_gallery_id = $gallery_id;
        if ($model->load(Yii::$app->request->post())) {
            $model->photo_url = UploadedFile::getInstance($model, 'photo_url');
            if (!empty($model->photo_url)) {
                $photo_url = 'images/modules/contentPhoto_' . date("YmdHis") . '.' . $model->photo_url->extension;
                if ($model->photo_url->saveAs($photo_url))
                    $model->photo_url = $photo_url;
            }
            if ($model->save())
                return $this->redirect(['index', 'gallery_id' => $model->photo_gallery_id]);
        }
        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing ContentPhotoList model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_photo_url = $model->photo_url;
        if ($model->load(Yii::$app->request->post())) {
            $model->photo_url = UploadedFile::getInstance($model, 'photo_url');
            if (!empty($model->photo_url)) {
                $photo_url = 'images/modules/contentPhoto_' . date("YmdHis") . '.' . $model->photo_url->extension;
                if ($model->photo_url->saveAs($photo_url))
                    $model->photo_url = $photo_url;
            }else{
                $model->photo_url = $original_photo_url;
            }
            if ($model->save()){
                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentPhotoList::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->photo_descr = $_POST['old_descr_' . $oldtranslation];
                            $modeltranslationupdate->photo_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save(false);
                        }
                    }
                }
                return $this->redirect(['index', 'gallery_id' => $model->photo_gallery_id]);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentPhotoList model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentPhotoList::deleteAll(['photo_parent_id' => $id]);
        $model = $this->findModel($id);
        $photo_gallery_id = $model->photo_gallery_id;
        $model->delete();
        return $this->redirect(['index', 'gallery_id' => $photo_gallery_id]);
    }

    /**
     * Finds the ContentPhotoList model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentPhotoList the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentPhotoList::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionAddtranslation($id) {
        $modeltranslation = new ContentPhotoList();
        $modeltranslation->photo_parent_id = $id;
        $modeltranslation->photo_main = 0;
        $modeltranslation->created_at = date("Y-m-d H:i:s");
        $modeltranslation->created_by = Yii::$app->user->identity->id;
        $modeltranslation->updated_at = date("Y-m-d H:i:s");
        $modeltranslation->updated_by = Yii::$app->user->identity->id;
        if ($modeltranslation->save(false))
            return $this->redirect(['update', 'id' => $id]);
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentPhotoList::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
