<?php

namespace backend\modules\contentPhoto\controllers;

use Yii;
use backend\modules\contentPhoto\models\ContentPhotoGallery;
use backend\modules\contentPhoto\models\ContentPhotoGallerySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentPhotoGalleryController implements the CRUD actions for ContentPhotoGallery model.
 */
class ContentPhotoGalleryController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentPhotoGallery models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentPhotoGallerySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentPhotoGallery model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentPhotoGallery model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentPhotoGallery();
        $model->scenario = 'create';
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->gallery_main = 1;
        if ($model->load(Yii::$app->request->post())) {
            $model->gallery_thumbnail = UploadedFile::getInstance($model, 'gallery_thumbnail');
            if (!empty($model->gallery_thumbnail)) {
                $gallery_thumbnail = 'images/modules/contentPhotoThumbnail_' . date("YmdHis") . '.' . $model->gallery_thumbnail->extension;
                if ($model->gallery_thumbnail->saveAs($gallery_thumbnail))
                    $model->gallery_thumbnail = $gallery_thumbnail;
            }
            if ($model->save())
                return $this->redirect(['index']);
        }
        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing ContentPhotoGallery model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_gallery_thumbnail = $model->gallery_thumbnail;
        if ($model->load(Yii::$app->request->post())) {
            $model->gallery_thumbnail = UploadedFile::getInstance($model, 'gallery_thumbnail');
            if (!empty($model->gallery_thumbnail)) {
                $gallery_thumbnail = 'images/modules/contentPhotoThumbnail_' . date("YmdHis") . '.' . $model->gallery_thumbnail->extension;
                if ($model->gallery_thumbnail->saveAs($gallery_thumbnail))
                    $model->gallery_thumbnail = $gallery_thumbnail;
            } else {
                $model->gallery_thumbnail = $original_gallery_thumbnail;
            }
            if ($model->save()) {
                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentPhotoGallery::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->gallery_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->gallery_descr = $_POST['old_descr_' . $oldtranslation];
                            $modeltranslationupdate->gallery_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save(false);
                        }
                    }
                }
                return $this->redirect(['index']);
            }
        }

        return $this->render('update', [
                    'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ContentPhotoGallery model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentPhotoGallery::deleteAll(['gallery_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentPhotoGallery model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentPhotoGallery the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentPhotoGallery::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionAddtranslation($id) {
        $modeltranslation = new ContentPhotoGallery();
        $modeltranslation->gallery_parent_id = $id;
        $modeltranslation->gallery_main = 0;
        $modeltranslation->created_at = date("Y-m-d H:i:s");
        $modeltranslation->created_by = Yii::$app->user->identity->id;
        $modeltranslation->updated_at = date("Y-m-d H:i:s");
        $modeltranslation->updated_by = Yii::$app->user->identity->id;
        if ($modeltranslation->save(false))
            return $this->redirect(['update', 'id' => $id]);
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentPhotoGallery::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
