<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentNewspaper\models\ContentNewspaperTranslation;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentNewspaper\models\ContentNewspaperSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Newspaper');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Newspaper'), ['create'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'API Newspaper List'), ['/api/api/view?api_code=ContentNewspaperList'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
        <?= Html::a(Yii::t('app', 'API Newspaper Details'), ['/api/api/view?api_code=ContentNewspaperDetails'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'newspaper_title',
                        'value' => function ($model) {
                            if (($modeltranslation = ContentNewspaperTranslation::findOne(['newspaper_translation_parent_id' => $model->newspaper_id, 'newspaper_translation_main' => 1])) !== null) {
                                return $modeltranslation->newspaper_translation_title;
                            }
                        }
                    ],
                    [
                        'attribute' => 'newspaper_portal_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'NPPORTAL'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'NPPORTAL'])
                                    ->andwhere(['=', 'code', $model->newspaper_portal_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'newspaper_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'NPCATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'NPCATEGORY'])
                                    ->andwhere(['=', 'code', $model->newspaper_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ], [
                        'attribute' => 'newspaper_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'NPSTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'NPSTATUS'])
                                    ->andwhere(['=', 'code', $model->newspaper_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'newspaper_date',
                        'headerOptions' => ['style' => 'width:10%'],
                    ], [
                        'header' => 'Language',
                        'format' => 'raw',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_newspaper_translation')
                                                    ->orderBy(['newspaper_translation_language' => SORT_ASC])
                                                    ->groupby(['newspaper_translation_language'])
                                                    ->all(), 'newspaper_translation_language', 'newspaper_translation_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'NPLANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentNewspaperTranslation::findOne(['newspaper_translation_parent_id' => $model->newspaper_id, 'newspaper_translation_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output;
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
