<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\contentNewspaper\models\ContentNewspaperTranslation;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentNewspaper\models\ContentNewspaper */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerCssFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css');
$this->registerJsFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('#contentnewspaper-newspaper_date').datepicker({'format':'yyyy-mm-dd'});
    $('.summernote').summernote({height: 300});
    $('#w0').on('keyup keypress', function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13) { 
          e.preventDefault();
          return false;
        }
      });
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}
    .bootstrap-tagsinput input, .bootstrap-tagsinput {width:100% !important;}");
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'newspaper_portal_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'NPPORTAL'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'newspaper_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'NPCATEGORY'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'onchange' => 'changecategory(this.value)', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'newspaper_subcategory')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'NPSUBCATEGORY'])
                                            ->andwhere(['=', 'param1', $model->newspaper_category])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'newspaper_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'NPSTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-4"><?= $form->field($model, 'newspaper_date')->textInput() ?></div>

                <div class="col-sm-4"><?= $form->field($model, 'newspaper_sorting')->textInput() ?></div>
                <div class="col-sm-12"><?= $form->field($model, 'newspaper_url')->textInput(['maxlength' => true]) ?></div>
            </div>
            <?php
            $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
            if (!empty($model->newspaper_image)) {
                echo $form->field($model, 'newspaper_image')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'initialPreview' => [
                            '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->newspaper_image . '"/>',
                        ],
                    ]
                ]);
            } else {
                echo $form->field($model, 'newspaper_image')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                ]);
            }
            ?>
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'newspaper_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'NPLANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-8"><?= $form->field($model, 'newspaper_title')->textInput() ?></div>
            </div>


            <?= $form->field($model, 'newspaper_content')->textarea(['class' => 'summernote']) ?>
            *Press "Enter" to separate the tag
            <?= $form->field($model, 'newspaper_tag')->textInput(['maxlength' => true, 'data-role' => 'tagsinput']) ?>
        </div> 
    </div>
    <?php
    $modeltranslation = ContentNewspaperTranslation::find()
                    ->where(['=', 'newspaper_translation_parent_id', $model->newspaper_id])
                    ->andwhere(['=', 'newspaper_translation_main', '0'])
                    ->orderBy(['newspaper_translation_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->newspaper_translation_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->newspaper_translation_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->newspaper_translation_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Newspaper Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->newspaper_translation_id, $rowtranslation->newspaper_translation_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'NPLANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->newspaper_translation_id . '" value="' . $rowtranslation->newspaper_translation_title . '">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="old_content_' . $rowtranslation->newspaper_translation_id . '">' . $rowtranslation->newspaper_translation_content . '</textarea>
                </div>
                <div class="form-group">
                    *Press "Enter" to separate the tag<br>
                    <label>Tag</label>
                    <input type="text" class="form-control tagsinput" data-role="tagsinput" name="old_tag_' . $rowtranslation->newspaper_translation_id . '" value="' . $rowtranslation->newspaper_translation_tag . '">
                </div>
            </div>
        </div>';
        }
    }
    ?>
    <div id="wrapper-translation"></div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        <?php
        if (!$model->isNewRecord)
            echo Html::button('Add Translation', ['class' => 'btn btn-primary', 'onclick' => 'addtranslation()']);
        ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function changecategory(parent_code) {
        $.ajax({
            url: "getsubcategory?parent_code=" + parent_code,
            method: "GET",
            success: function (response) {
                $('#contentnewspaper-newspaper_subcategory').find('option').not(':first').remove();
                $('#contentnewspaper-newspaper_subcategory').append(response);
            },
        });
    }

    var newcount = 1;
    function addtranslation() {
        newcount++;
        $.ajax({
            url: "addtranslation?no=" + newcount,
            method: "GET",
            success: function (response) {
                $('#wrapper-translation').append(response);
                $('.summernote').summernote({height: 300});
                $('.tagsinput').tagsinput('refresh');
            },
        });
    }

    function deletenewtranslation(no) {
        $('#new-translation-' + no).remove();
    }

    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>