CREATE TABLE IF NOT EXISTS `content_newspaper` (
  `newspaper_id` int(11) NOT NULL AUTO_INCREMENT,
  `newspaper_date` date DEFAULT NULL,
  `newspaper_category` varchar(255) DEFAULT NULL,
  `newspaper_subcategory` varchar(255) DEFAULT NULL,
  `newspaper_status` varchar(255) DEFAULT NULL,
  `newspaper_url` varchar(255) DEFAULT NULL,
  `newspaper_sorting` int(11) DEFAULT NULL,
  `newspaper_image` varchar(255) DEFAULT NULL,
  `newspaper_portal_category` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`newspaper_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `content_newspaper_translation` (
  `newspaper_translation_id` int(11) NOT NULL AUTO_INCREMENT,
  `newspaper_translation_parent_id` int(11) DEFAULT NULL,
  `newspaper_translation_title` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `newspaper_translation_content` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `newspaper_translation_tag` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `newspaper_translation_main` int(11) DEFAULT NULL,
  `newspaper_translation_language` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`newspaper_translation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr_en` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `param1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `deleted_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

insert  into `ref`(`cat`,`code`,`descr`,`descr_en`,`sort`,`param1`,`icon_name`,`created_by`,`created_at`,`updated_by`,`updated_at`,`deleted_at`) values 
('NPSTATUS','active','Active',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPSTATUS','inactive','Inactive',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPSTATUS','archived','Archived',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPPORTAL','portal01','Homepage',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPCATEGORY','npcategory01','Main Newspaper',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Malay','Malay',NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Chinese','Chinese',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','English','English',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Hindi','Hindi',NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Arabic','Arabic',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Japanese','Japanese',NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Tamil','Tamil',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('NPLANGUAGE','Korean','Korean',NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

CREATE TABLE IF NOT EXISTS `api` (
  `api_id` int(11) NOT NULL AUTO_INCREMENT,
  `api_code` varchar(255) DEFAULT NULL,
  `api_descr` text DEFAULT NULL,
  `api_content` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

insert  into `api`(`api_code`,`api_descr`,`api_content`,`created_at`,`created_by`,`updated_at`,`updated_by`) values 
('ContentNewspaperList','This is the API to display all the list of newspaper','<?php \r\n\r\n$sql = \"SELECT * FROM content_newspaper_translation t1 \r\n    INNER JOIN content_newspaper t2 ON t1.newspaper_translation_parent_id=t2.newspaper_id\";\r\n$model = Yii::$app->db->createCommand($sql)->queryAll();\r\n$arr = [];\r\n$status = \'failed\';\r\nif(!empty($model)){\r\n    foreach($model as $row){\r\n        $status = \'success\';\r\n        $arr2 = [];\r\n        $arr2[\'language\'] = $row[\'newspaper_translation_language\'];\r\n        $arr2[\'title\'] = $row[\'newspaper_translation_title\'];\r\n        $arr2[\'content\'] = $row[\'newspaper_translation_content\'];\r\n        $arr2[\'tag\'] = $row[\'newspaper_translation_tag\'];\r\n        \r\n        $arr2[\'portal_category\'] = $row[\'newspaper_portal_category\'];\r\n        $arr2[\'category\'] = $row[\'newspaper_category\'];\r\n        $arr2[\'subcategory\'] = $row[\'newspaper_subcategory\'];\r\n        $arr2[\'status\'] = $row[\'newspaper_status\'];\r\n        $arr2[\'newspaper_date\'] = $row[\'newspaper_date\'];\r\n        $arr2[\'sorting\'] = $row[\'newspaper_sorting\'];\r\n        $arr2[\'url_related\'] = $row[\'newspaper_url\'];\r\n        $arr2[\'thumbnail\'] = $row[\'newspaper_image\'];\r\n        \r\n        $arr[] = $arr2;\r\n    }\r\n}\r\necho json_encode([\'result_status\'=>$status,\'data\'=>$arr]);',NOW(),3,NOW(),3),
('ContentNewspaperDetails','This is the API to display the details of the newspaper','<?php \r\n$newspaper_id = \'\';\r\n$arr = [];\r\n$status = \'failed\';\r\n$remark = \'\';\r\nif(isset($_GET[\'newspaper_id\'])&&!empty($_GET[\'newspaper_id\'])){\r\n    $newspaper_id = $_GET[\'newspaper_id\'];\r\n    $sql = \"SELECT * FROM content_newspaper_translation t1 \r\n        INNER JOIN content_newspaper t2 ON t1.newspaper_translation_parent_id=t2.newspaper_id WHERE t2.newspaper_id=\".$newspaper_id;\r\n    $model = Yii::$app->db->createCommand($sql)->queryAll();\r\n    \r\n    if(!empty($model)){\r\n        foreach($model as $row){\r\n            $status = \'success\';\r\n            $arr2 = [];\r\n            $arr2[\'language\'] = $row[\'newspaper_translation_language\'];\r\n            $arr2[\'title\'] = $row[\'newspaper_translation_title\'];\r\n            $arr2[\'content\'] = $row[\'newspaper_translation_content\'];\r\n            $arr2[\'tag\'] = $row[\'newspaper_translation_tag\'];\r\n            \r\n            $arr2[\'portal_category\'] = $row[\'newspaper_portal_category\'];\r\n            $arr2[\'category\'] = $row[\'newspaper_category\'];\r\n            $arr2[\'subcategory\'] = $row[\'newspaper_subcategory\'];\r\n            $arr2[\'status\'] = $row[\'newspaper_status\'];\r\n            $arr2[\'newspaper_date\'] = $row[\'newspaper_date\'];\r\n            $arr2[\'sorting\'] = $row[\'newspaper_sorting\'];\r\n            $arr2[\'url_related\'] = $row[\'newspaper_url\'];\r\n            $arr2[\'thumbnail\'] = $row[\'newspaper_image\'];\r\n            \r\n            $arr[] = $arr2;\r\n        }\r\n    }else{\r\n        $remark = \'Record not found\';\r\n    }\r\n    \r\n}else{\r\n    $remark = \'Please specify the newspaper_id using $_GET method\';\r\n}\r\necho json_encode([\'result_status\'=>$status,\'remark\'=>$remark,\'data\'=>$arr]);',NOW(),3,NOW(),3);

insert  into `backend_menu`(`menu_name`,`menu_param`,`menu_class`,`menu_link`,`menu_active_route`,`menu_parent_id`,`menu_status`) values 
('Newspaper','','fa fa-newspaper','/contentNewspaper/content-newspaper/index','',0,1);

insert  into `route`(`name`,`alias`,`type`,`status`) values ('/contentNewspaper/content-newspaper/index','index','contentNewspaper/content-newspaper',1);