<?php

namespace backend\modules\contentNewspaper\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentNewspaper\models\ContentNewspaperTranslation;

/**
 * ContentNewspaperTranslationSearch represents the model behind the search form of `backend\modules\contentNewspaper\models\ContentNewspaperTranslation`.
 */
class ContentNewspaperTranslationSearch extends ContentNewspaperTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['newspaper_translation_id', 'newspaper_translation_parent_id', 'created_by', 'updated_by'], 'integer'],
            [['newspaper_translation_title', 'newspaper_translation_content', 'newspaper_translation_tag', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ContentNewspaperTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'newspaper_translation_id' => $this->newspaper_translation_id,
            'newspaper_translation_parent_id' => $this->newspaper_translation_parent_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'newspaper_translation_title', $this->newspaper_translation_title])
            ->andFilterWhere(['like', 'newspaper_translation_content', $this->newspaper_translation_content])
            ->andFilterWhere(['like', 'newspaper_translation_tag', $this->newspaper_translation_tag]);

        return $dataProvider;
    }
}
