<?php

namespace backend\modules\contentNewspaper\models;

use Yii;

/**
 * This is the model class for table "content_newspaper_translation".
 *
 * @property int $newspaper_translation_id
 * @property int|null $newspaper_translation_parent_id
 * @property string|null $newspaper_translation_title
 * @property string|null $newspaper_translation_content
 * @property string|null $newspaper_translation_tag
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentNewspaperTranslation extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_newspaper_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['newspaper_translation_parent_id', 'created_by', 'updated_by', 'newspaper_translation_main'], 'integer'],
            [['newspaper_translation_title', 'newspaper_translation_content', 'newspaper_translation_tag'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'newspaper_translation_id' => Yii::t('app', 'Newspaper Translation ID'),
            'newspaper_translation_parent_id' => Yii::t('app', 'Newspaper Translation Parent ID'),
            'newspaper_translation_title' => Yii::t('app', 'Newspaper Translation Title'),
            'newspaper_translation_content' => Yii::t('app', 'Newspaper Translation Content'),
            'newspaper_translation_tag' => Yii::t('app', 'Newspaper Translation Tag'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
