<?php

namespace backend\modules\contentNewspaper\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentNewspaper\models\ContentNewspaper;

/**
 * ContentNewspaperSearch represents the model behind the search form of `backend\modules\contentNewspaper\models\ContentNewspaper`.
 */
class ContentNewspaperSearch extends ContentNewspaper {

    public $newspaper_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['newspaper_id', 'newspaper_sorting', 'created_by', 'updated_by'], 'integer'],
            [['newspaper_date', 'newspaper_category', 'newspaper_status', 'newspaper_url', 'newspaper_image', 'newspaper_portal_category', 'created_at', 'updated_at', 'newspaper_title'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentNewspaper::find()
                ->innerJoin('content_newspaper_translation', 'content_newspaper_translation.newspaper_translation_parent_id=content_newspaper.newspaper_id')
                ->where(['=', 'content_newspaper_translation.newspaper_translation_main', '1']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['LIKE', 'newspaper_date', $this->newspaper_date]);
        $query->andFilterWhere(['=', 'newspaper_category', $this->newspaper_category]);
        $query->andFilterWhere(['=', 'newspaper_status', $this->newspaper_status]);
        $query->andFilterWhere(['LIKE', 'newspaper_translation_title', $this->newspaper_title]);


        return $dataProvider;
    }

}
