<?php

namespace backend\modules\contentNewspaper\models;

use Yii;

/**
 * This is the model class for table "content_newspaper".
 *
 * @property int $newspaper_id
 * @property string|null $newspaper_date
 * @property string|null $newspaper_category
 * @property string|null $newspaper_status
 * @property string|null $newspaper_url
 * @property int|null $newspaper_sorting
 * @property string|null $newspaper_image
 * @property string|null $newspaper_portal_category
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentNewspaper extends \yii\db\ActiveRecord {

    public $newspaper_title;
    public $newspaper_tag;
    public $newspaper_content;
    public $newspaper_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_newspaper';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['newspaper_title', 'newspaper_content', 'newspaper_language','newspaper_category'], 'required'],
            [['newspaper_date', 'created_at', 'updated_at', 'newspaper_subcategory', 'newspaper_tag'], 'safe'],
            [['newspaper_sorting', 'created_by', 'updated_by'], 'integer'],
            [['newspaper_category', 'newspaper_status', 'newspaper_url', 'newspaper_image', 'newspaper_portal_category'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'newspaper_id' => Yii::t('app', 'Newspaper ID'),
            'newspaper_date' => Yii::t('app', 'Newspaper Date'),
            'newspaper_category' => Yii::t('app', 'Category'),
            'newspaper_subcategory' => Yii::t('app', 'Subcategory'),
            'newspaper_status' => Yii::t('app', 'Status'),
            'newspaper_url' => Yii::t('app', 'URL Related'),
            'newspaper_sorting' => Yii::t('app', 'Sorting'),
            'newspaper_image' => Yii::t('app', 'Thumbnail'),
            'newspaper_portal_category' => Yii::t('app', 'Portal Category'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'newspaper_title' => Yii::t('app', 'Title'),
            'newspaper_content' => Yii::t('app', 'Content'),
            'newspaper_language' => Yii::t('app', 'Language'),
            'newspaper_tag' => Yii::t('app', 'Tag'),
        ];
    }

}
