<?php

namespace backend\modules\contentNewspaper\controllers;

use Yii;
use backend\modules\contentNewspaper\models\ContentNewspaper;
use backend\modules\contentNewspaper\models\ContentNewspaperTranslation;
use backend\modules\contentNewspaper\models\ContentNewspaperSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentNewspaperController implements the CRUD actions for ContentNewspaper model.
 */
class ContentNewspaperController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentNewspaper models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentNewspaperSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentNewspaper model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentNewspaper model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentNewspaper();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->newspaper_language = 'Malay';
        if ($model->load(Yii::$app->request->post())) {
            $model->newspaper_image = UploadedFile::getInstance($model, 'newspaper_image');
            if (!empty($model->newspaper_image)) {
                $newspaper_image = 'images/modules/contentNewspaper_' . date("YmdHis") . '.' . $model->newspaper_image->extension;
                if ($model->newspaper_image->saveAs($newspaper_image))
                    $model->newspaper_image = $newspaper_image;
            }
            if ($model->save()) {

                $modeltranslation = new ContentNewspaperTranslation();
                $modeltranslation->newspaper_translation_parent_id = $model->newspaper_id;
                $modeltranslation->newspaper_translation_title = $model->newspaper_title;
                $modeltranslation->newspaper_translation_content = $model->newspaper_content;
                $modeltranslation->newspaper_translation_tag = $model->newspaper_tag;
                $modeltranslation->newspaper_translation_language = $model->newspaper_language;
                $modeltranslation->newspaper_translation_main = 1;
                $modeltranslation->created_at = date("Y-m-d H:i:s");
                $modeltranslation->created_by = Yii::$app->user->identity->id;
                $modeltranslation->updated_at = date("Y-m-d H:i:s");
                $modeltranslation->updated_by = Yii::$app->user->identity->id;
                $modeltranslation->save();

                return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing ContentNewspaper model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_thumbnail = $model->newspaper_image;

        $translation_id = '';

        if (($modeltranslation = ContentNewspaperTranslation::findOne(['newspaper_translation_parent_id' => $model->newspaper_id, 'newspaper_translation_main' => 1])) !== null) {
            $translation_id = $modeltranslation->newspaper_translation_id;
            $model->newspaper_title = $modeltranslation->newspaper_translation_title;
            $model->newspaper_content = $modeltranslation->newspaper_translation_content;
            $model->newspaper_tag = $modeltranslation->newspaper_translation_tag;
            $model->newspaper_language = $modeltranslation->newspaper_translation_language;
        }

        if ($model->load(Yii::$app->request->post())) {
            $model->newspaper_image = UploadedFile::getInstance($model, 'newspaper_image');
            if (!empty($model->newspaper_image)) {
                $newspaper_image = 'images/modules/contentNewspaper_' . date("YmdHis") . '.' . $model->newspaper_image->extension;
                if ($model->newspaper_image->saveAs($newspaper_image))
                    $model->newspaper_image = $newspaper_image;
            } else
                $model->newspaper_image = $original_thumbnail;
            if ($model->save()) {
                if (($modeltranslation = ContentNewspaperTranslation::findOne($translation_id)) !== null) {
                    $modeltranslation->newspaper_translation_title = $model->newspaper_title;
                    $modeltranslation->newspaper_translation_content = $model->newspaper_content;
                    $modeltranslation->newspaper_translation_tag = $model->newspaper_tag;
                    $modeltranslation->newspaper_translation_language = $model->newspaper_language;
                    $modeltranslation->updated_at = date("Y-m-d H:i:s");
                    $modeltranslation->updated_by = Yii::$app->user->identity->id;
                    $modeltranslation->save();
                }

                //insert new translation
                if (isset($_POST['newtranslation']) && !empty($_POST['newtranslation'])) {
                    foreach ($_POST['newtranslation'] as $newno) {
                        $modeltranslationnew = new ContentNewspaperTranslation();
                        $modeltranslationnew->newspaper_translation_parent_id = $model->newspaper_id;
                        $modeltranslationnew->newspaper_translation_title = $_POST['new_title_' . $newno];
                        $modeltranslationnew->newspaper_translation_content = $_POST['new_content_' . $newno];
                        $modeltranslationnew->newspaper_translation_tag = $_POST['new_tag_' . $newno];
                        $modeltranslationnew->newspaper_translation_language = $_POST['new_language_' . $newno];
                        $modeltranslationnew->newspaper_translation_main = 0;
                        $modeltranslationnew->created_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->created_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->updated_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->updated_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->save();
                    }
                }

                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentNewspaperTranslation::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->newspaper_translation_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->newspaper_translation_content = $_POST['old_content_' . $oldtranslation];
                            $modeltranslationupdate->newspaper_translation_tag = $_POST['old_tag_' . $oldtranslation];
                            $modeltranslationupdate->newspaper_translation_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save();
                        }
                    }
                }

                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentNewspaper model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentNewspaperTranslation::deleteAll(['newspaper_translation_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentNewspaper model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentNewspaper the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentNewspaper::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionGetsubcategory($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr'])
                                ->from('ref')
                                ->where(['=', 'cat', 'NPSUBCATEGORY'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['sort' => SORT_ASC])
                                ->all(), 'code', 'descr');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }

    public function actionAddtranslation($no = '') {
        $output = '<div class="ibox float-e-margins" id="new-translation-' . $no . '">
            <input type="hidden" name="newtranslation[]" value="' . $no . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deletenewtranslation(' . $no . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                New Newspaper Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('new_language_' . $no, NULL, ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'NPLANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'), [
                    'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8"><div class="form-group"><label>Title</label><input type="text" class="form-control" name="new_title_' . $no . '"></div></div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="new_content_' . $no . '"></textarea>
                </div>
                <div class="form-group">
                    *Press "Enter" to separate the tag<br>
                    <label>Tag</label>
                    <input type="text" class="form-control tagsinput" data-role="tagsinput" name="new_tag_' . $no . '">
                </div>
            </div>
        </div>';
        return $output;
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentNewspaperTranslation::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
