<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentMediaStatement\models\ContentMediaStatementTranslation;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentMediaStatement\models\ContentMediaStatementSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Media Statement');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Media Statement'), ['create'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'API Media Statement List'), ['/api/api/view?api_code=ContentMediaStatementList'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
        <?= Html::a(Yii::t('app', 'API Media Statement Details'), ['/api/api/view?api_code=ContentMediaStatementDetails'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'media_statement_title',
                        'value' => function ($model) {
                            if (($modeltranslation = ContentMediaStatementTranslation::findOne(['media_statement_translation_parent_id' => $model->media_statement_id, 'media_statement_translation_main' => 1])) !== null) {
                                return $modeltranslation->media_statement_translation_title;
                            }
                        }
                    ],
                    [
                        'attribute' => 'media_statement_portal_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLEPORTAL'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLEPORTAL'])
                                    ->andwhere(['=', 'code', $model->media_statement_portal_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'media_statement_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLECATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLECATEGORY'])
                                    ->andwhere(['=', 'code', $model->media_statement_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ], [
                        'attribute' => 'media_statement_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLESTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLESTATUS'])
                                    ->andwhere(['=', 'code', $model->media_statement_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'media_statement_date',
                        'headerOptions' => ['style' => 'width:10%'],
                    ], [
                        'header' => 'Language',
                        'format' => 'raw',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_media_statement_translation')
                                                    ->orderBy(['media_statement_translation_language' => SORT_ASC])
                                                    ->groupby(['media_statement_translation_language'])
                                                    ->all(), 'media_statement_translation_language', 'media_statement_translation_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLELANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentMediaStatementTranslation::findOne(['media_statement_translation_parent_id' => $model->media_statement_id, 'media_statement_translation_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output;
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
