CREATE TABLE IF NOT EXISTS `content_media_statement` (
  `media_statement_id` int(11) NOT NULL AUTO_INCREMENT,
  `media_statement_date` date DEFAULT NULL,
  `media_statement_category` varchar(255) DEFAULT NULL,
  `media_statement_subcategory` varchar(255) DEFAULT NULL,
  `media_statement_status` varchar(255) DEFAULT NULL,
  `media_statement_url` varchar(255) DEFAULT NULL,
  `media_statement_sorting` int(11) DEFAULT NULL,
  `media_statement_image` varchar(255) DEFAULT NULL,
  `media_statement_portal_category` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`media_statement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `content_media_statement_translation` (
  `media_statement_translation_id` int(11) NOT NULL AUTO_INCREMENT,
  `media_statement_translation_parent_id` int(11) DEFAULT NULL,
  `media_statement_translation_title` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `media_statement_translation_content` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `media_statement_translation_tag` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `media_statement_translation_main` int(11) DEFAULT NULL,
  `media_statement_translation_language` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`media_statement_translation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr_en` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `param1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `deleted_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

insert  into `ref`(`cat`,`code`,`descr`,`descr_en`,`sort`,`param1`,`icon_name`,`created_by`,`created_at`,`updated_by`,`updated_at`,`deleted_at`) values 
('MSSTATUS','active','Active',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSSTATUS','inactive','Inactive',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSSTATUS','archived','Archived',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSPORTAL','portal01','Main Portal',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSCATEGORY','mscategory01','Main MediaStatement',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Malay','Malay',NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Chinese','Chinese',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','English','English',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Hindi','Hindi',NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Arabic','Arabic',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Japanese','Japanese',NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Tamil','Tamil',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('MSLANGUAGE','Korean','Korean',NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

CREATE TABLE IF NOT EXISTS `api` (
  `api_id` int(11) NOT NULL AUTO_INCREMENT,
  `api_code` varchar(255) DEFAULT NULL,
  `api_descr` text DEFAULT NULL,
  `api_content` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

insert  into `api`(`api_code`,`api_descr`,`api_content`,`created_at`,`created_by`,`updated_at`,`updated_by`) values 
('ContentMediaStatementList','This is the API to display all the list of media statement','<?php \r\n\r\n$sql = \"SELECT * FROM content_media_statement_translation t1 \r\n    INNER JOIN content_media_statement t2 ON t1.media_statement_translation_parent_id=t2.media_statement_id\";\r\n$model = Yii::$app->db->createCommand($sql)->queryAll();\r\n$arr = [];\r\n$status = \'failed\';\r\nif(!empty($model)){\r\n    foreach($model as $row){\r\n        $status = \'success\';\r\n        $arr2 = [];\r\n        $arr2[\'language\'] = $row[\'media_statement_translation_language\'];\r\n        $arr2[\'title\'] = $row[\'media_statement_translation_title\'];\r\n        $arr2[\'content\'] = $row[\'media_statement_translation_content\'];\r\n        $arr2[\'tag\'] = $row[\'media_statement_translation_tag\'];\r\n        \r\n        $arr2[\'portal_category\'] = $row[\'media_statement_portal_category\'];\r\n        $arr2[\'category\'] = $row[\'media_statement_category\'];\r\n        $arr2[\'subcategory\'] = $row[\'media_statement_subcategory\'];\r\n        $arr2[\'status\'] = $row[\'media_statement_status\'];\r\n        $arr2[\'media_statement_date\'] = $row[\'media_statement_date\'];\r\n        $arr2[\'sorting\'] = $row[\'media_statement_sorting\'];\r\n        $arr2[\'url_related\'] = $row[\'media_statement_url\'];\r\n        $arr2[\'thumbnail\'] = $row[\'media_statement_image\'];\r\n        \r\n        $arr[] = $arr2;\r\n    }\r\n}\r\necho json_encode([\'result_status\'=>$status,\'data\'=>$arr]);',NOW(),3,NOW(),3),
('ContentMediaStatementDetails','This is the API to display the details of the media statement','<?php \r\n$media_statement_id = \'\';\r\n$arr = [];\r\n$status = \'failed\';\r\n$remark = \'\';\r\nif(isset($_GET[\'media_statement_id\'])&&!empty($_GET[\'media_statement_id\'])){\r\n    $media_statement_id = $_GET[\'media_statement_id\'];\r\n    $sql = \"SELECT * FROM content_media_statement_translation t1 \r\n        INNER JOIN content_media_statement t2 ON t1.media_statement_translation_parent_id=t2.media_statement_id WHERE t2.media_statement_id=\".$media_statement_id;\r\n    $model = Yii::$app->db->createCommand($sql)->queryAll();\r\n    \r\n    if(!empty($model)){\r\n        foreach($model as $row){\r\n            $status = \'success\';\r\n            $arr2 = [];\r\n            $arr2[\'language\'] = $row[\'media_statement_translation_language\'];\r\n            $arr2[\'title\'] = $row[\'media_statement_translation_title\'];\r\n            $arr2[\'content\'] = $row[\'media_statement_translation_content\'];\r\n            $arr2[\'tag\'] = $row[\'media_statement_translation_tag\'];\r\n            \r\n            $arr2[\'portal_category\'] = $row[\'media_statement_portal_category\'];\r\n            $arr2[\'category\'] = $row[\'media_statement_category\'];\r\n            $arr2[\'subcategory\'] = $row[\'media_statement_subcategory\'];\r\n            $arr2[\'status\'] = $row[\'media_statement_status\'];\r\n            $arr2[\'media_statement_date\'] = $row[\'media_statement_date\'];\r\n            $arr2[\'sorting\'] = $row[\'media_statement_sorting\'];\r\n            $arr2[\'url_related\'] = $row[\'media_statement_url\'];\r\n            $arr2[\'thumbnail\'] = $row[\'media_statement_image\'];\r\n            \r\n            $arr[] = $arr2;\r\n        }\r\n    }else{\r\n        $remark = \'Record not found\';\r\n    }\r\n    \r\n}else{\r\n    $remark = \'Please specify the media statement_id using $_GET method\';\r\n}\r\necho json_encode([\'result_status\'=>$status,\'remark\'=>$remark,\'data\'=>$arr]);',NOW(),3,NOW(),3);

insert  into `backend_menu`(`menu_name`,`menu_param`,`menu_class`,`menu_link`,`menu_active_route`,`menu_parent_id`,`menu_status`) values 
('Media Statement','','fa fa-comments-o','/contentMediaStatement/content-media-statement/index','',0,1);

insert  into `route`(`name`,`alias`,`type`,`status`) values ('/contentMediaStatement/content-media-statement/index','index','contentMediaStatement/content-media-statement',1);