<?php

namespace backend\modules\contentMediaStatement\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentMediaStatement\models\ContentMediaStatementTranslation;

/**
 * ContentMediaStatementTranslationSearch represents the model behind the search form of `backend\modules\contentMediaStatement\models\ContentMediaStatementTranslation`.
 */
class ContentMediaStatementTranslationSearch extends ContentMediaStatementTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['media_statement_translation_id', 'media_statement_translation_parent_id', 'created_by', 'updated_by'], 'integer'],
            [['media_statement_translation_title', 'media_statement_translation_content', 'media_statement_translation_tag', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ContentMediaStatementTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'media_statement_translation_id' => $this->media_statement_translation_id,
            'media_statement_translation_parent_id' => $this->media_statement_translation_parent_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'media_statement_translation_title', $this->media_statement_translation_title])
            ->andFilterWhere(['like', 'media_statement_translation_content', $this->media_statement_translation_content])
            ->andFilterWhere(['like', 'media_statement_translation_tag', $this->media_statement_translation_tag]);

        return $dataProvider;
    }
}
