<?php

namespace backend\modules\contentMediaStatement\models;

use Yii;

/**
 * This is the model class for table "content_media_statement_translation".
 *
 * @property int $media_statement_translation_id
 * @property int|null $media_statement_translation_parent_id
 * @property string|null $media_statement_translation_title
 * @property string|null $media_statement_translation_content
 * @property string|null $media_statement_translation_tag
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentMediaStatementTranslation extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_media_statement_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['media_statement_translation_parent_id', 'created_by', 'updated_by', 'media_statement_translation_main'], 'integer'],
            [['media_statement_translation_title', 'media_statement_translation_content', 'media_statement_translation_tag'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'media_statement_translation_id' => Yii::t('app', 'Media Statement Translation ID'),
            'media_statement_translation_parent_id' => Yii::t('app', 'Media Statement Translation Parent ID'),
            'media_statement_translation_title' => Yii::t('app', 'Media Statement Translation Title'),
            'media_statement_translation_content' => Yii::t('app', 'Media Statement Translation Content'),
            'media_statement_translation_tag' => Yii::t('app', 'Media Statement Translation Tag'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
