<?php

namespace backend\modules\contentMediaStatement\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentMediaStatement\models\ContentMediaStatement;

/**
 * ContentMediaStatementSearch represents the model behind the search form of `backend\modules\contentMediaStatement\models\ContentMediaStatement`.
 */
class ContentMediaStatementSearch extends ContentMediaStatement {

    public $media_statement_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['media_statement_id', 'media_statement_sorting', 'created_by', 'updated_by'], 'integer'],
            [['media_statement_date', 'media_statement_category', 'media_statement_status', 'media_statement_url', 'media_statement_image', 'media_statement_portal_category', 'created_at', 'updated_at', 'media_statement_title'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentMediaStatement::find()
                ->innerJoin('content_media_statement_translation', 'content_media_statement_translation.media_statement_translation_parent_id=content_media_statement.media_statement_id')
                ->where(['=', 'content_media_statement_translation.media_statement_translation_main', '1']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['LIKE', 'media_statement_date', $this->media_statement_date]);
        $query->andFilterWhere(['=', 'media_statement_category', $this->media_statement_category]);
        $query->andFilterWhere(['=', 'media_statement_status', $this->media_statement_status]);
        $query->andFilterWhere(['LIKE', 'media_statement_translation_title', $this->media_statement_title]);


        return $dataProvider;
    }

}
