<?php

namespace backend\modules\contentMediaStatement\models;

use Yii;

/**
 * This is the model class for table "content_media_statement".
 *
 * @property int $media_statement_id
 * @property string|null $media_statement_date
 * @property string|null $media_statement_category
 * @property string|null $media_statement_status
 * @property string|null $media_statement_url
 * @property int|null $media_statement_sorting
 * @property string|null $media_statement_image
 * @property string|null $media_statement_portal_category
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentMediaStatement extends \yii\db\ActiveRecord {

    public $media_statement_title;
    public $media_statement_tag;
    public $media_statement_content;
    public $media_statement_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_media_statement';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['media_statement_title', 'media_statement_content', 'media_statement_language','media_statement_category'], 'required'],
            [['media_statement_date', 'created_at', 'updated_at', 'media_statement_subcategory', 'media_statement_tag'], 'safe'],
            [['media_statement_sorting', 'created_by', 'updated_by'], 'integer'],
            [['media_statement_category', 'media_statement_status', 'media_statement_url', 'media_statement_image', 'media_statement_portal_category'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'media_statement_id' => Yii::t('app', 'Media Statement ID'),
            'media_statement_date' => Yii::t('app', 'Media Statement Date'),
            'media_statement_category' => Yii::t('app', 'Category'),
            'media_statement_subcategory' => Yii::t('app', 'Subcategory'),
            'media_statement_status' => Yii::t('app', 'Status'),
            'media_statement_url' => Yii::t('app', 'URL Related'),
            'media_statement_sorting' => Yii::t('app', 'Sorting'),
            'media_statement_image' => Yii::t('app', 'Thumbnail'),
            'media_statement_portal_category' => Yii::t('app', 'Portal Category'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'media_statement_title' => Yii::t('app', 'Title'),
            'media_statement_content' => Yii::t('app', 'Content'),
            'media_statement_language' => Yii::t('app', 'Language'),
            'media_statement_tag' => Yii::t('app', 'Tag'),
        ];
    }

}
