<?php

namespace backend\modules\contentMediaStatement\controllers;

use Yii;
use backend\modules\contentMediaStatement\models\ContentMediaStatement;
use backend\modules\contentMediaStatement\models\ContentMediaStatementTranslation;
use backend\modules\contentMediaStatement\models\ContentMediaStatementSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentMediaStatementController implements the CRUD actions for ContentMediaStatement model.
 */
class ContentMediaStatementController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentMediaStatement models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentMediaStatementSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentMediaStatement model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentMediaStatement model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentMediaStatement();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->media_statement_language = 'Malay';
        if ($model->load(Yii::$app->request->post())) {
            $model->media_statement_image = UploadedFile::getInstance($model, 'media_statement_image');
            if (!empty($model->media_statement_image)) {
                $media_statement_image = 'images/modules/contentMediaStatement_' . date("YmdHis") . '.' . $model->media_statement_image->extension;
                if ($model->media_statement_image->saveAs($media_statement_image))
                    $model->media_statement_image = $media_statement_image;
            }
            if ($model->save()) {

                $modeltranslation = new ContentMediaStatementTranslation();
                $modeltranslation->media_statement_translation_parent_id = $model->media_statement_id;
                $modeltranslation->media_statement_translation_title = $model->media_statement_title;
                $modeltranslation->media_statement_translation_content = $model->media_statement_content;
                $modeltranslation->media_statement_translation_tag = $model->media_statement_tag;
                $modeltranslation->media_statement_translation_language = $model->media_statement_language;
                $modeltranslation->media_statement_translation_main = 1;
                $modeltranslation->created_at = date("Y-m-d H:i:s");
                $modeltranslation->created_by = Yii::$app->user->identity->id;
                $modeltranslation->updated_at = date("Y-m-d H:i:s");
                $modeltranslation->updated_by = Yii::$app->user->identity->id;
                $modeltranslation->save();

                return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing ContentMediaStatement model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_thumbnail = $model->media_statement_image;

        $translation_id = '';

        if (($modeltranslation = ContentMediaStatementTranslation::findOne(['media_statement_translation_parent_id' => $model->media_statement_id, 'media_statement_translation_main' => 1])) !== null) {
            $translation_id = $modeltranslation->media_statement_translation_id;
            $model->media_statement_title = $modeltranslation->media_statement_translation_title;
            $model->media_statement_content = $modeltranslation->media_statement_translation_content;
            $model->media_statement_tag = $modeltranslation->media_statement_translation_tag;
            $model->media_statement_language = $modeltranslation->media_statement_translation_language;
        }

        if ($model->load(Yii::$app->request->post())) {
            $model->media_statement_image = UploadedFile::getInstance($model, 'media_statement_image');
            if (!empty($model->media_statement_image)) {
                $media_statement_image = 'images/modules/contentMediaStatement_' . date("YmdHis") . '.' . $model->media_statement_image->extension;
                if ($model->media_statement_image->saveAs($media_statement_image))
                    $model->media_statement_image = $media_statement_image;
            } else
                $model->media_statement_image = $original_thumbnail;
            if ($model->save()) {
                if (($modeltranslation = ContentMediaStatementTranslation::findOne($translation_id)) !== null) {
                    $modeltranslation->media_statement_translation_title = $model->media_statement_title;
                    $modeltranslation->media_statement_translation_content = $model->media_statement_content;
                    $modeltranslation->media_statement_translation_tag = $model->media_statement_tag;
                    $modeltranslation->media_statement_translation_language = $model->media_statement_language;
                    $modeltranslation->updated_at = date("Y-m-d H:i:s");
                    $modeltranslation->updated_by = Yii::$app->user->identity->id;
                    $modeltranslation->save();
                }

                //insert new translation
                if (isset($_POST['newtranslation']) && !empty($_POST['newtranslation'])) {
                    foreach ($_POST['newtranslation'] as $newno) {
                        $modeltranslationnew = new ContentMediaStatementTranslation();
                        $modeltranslationnew->media_statement_translation_parent_id = $model->media_statement_id;
                        $modeltranslationnew->media_statement_translation_title = $_POST['new_title_' . $newno];
                        $modeltranslationnew->media_statement_translation_content = $_POST['new_content_' . $newno];
                        $modeltranslationnew->media_statement_translation_tag = $_POST['new_tag_' . $newno];
                        $modeltranslationnew->media_statement_translation_language = $_POST['new_language_' . $newno];
                        $modeltranslationnew->media_statement_translation_main = 0;
                        $modeltranslationnew->created_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->created_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->updated_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->updated_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->save();
                    }
                }

                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentMediaStatementTranslation::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->media_statement_translation_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->media_statement_translation_content = $_POST['old_content_' . $oldtranslation];
                            $modeltranslationupdate->media_statement_translation_tag = $_POST['old_tag_' . $oldtranslation];
                            $modeltranslationupdate->media_statement_translation_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save();
                        }
                    }
                }

                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentMediaStatement model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentMediaStatementTranslation::deleteAll(['media_statement_translation_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentMediaStatement model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentMediaStatement the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentMediaStatement::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionGetsubcategory($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr'])
                                ->from('ref')
                                ->where(['=', 'cat', 'ARTICLESUBCATEGORY'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['sort' => SORT_ASC])
                                ->all(), 'code', 'descr');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }

    public function actionAddtranslation($no = '') {
        $output = '<div class="ibox float-e-margins" id="new-translation-' . $no . '">
            <input type="hidden" name="newtranslation[]" value="' . $no . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deletenewtranslation(' . $no . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                New MediaStatement Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('new_language_' . $no, NULL, ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLELANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'), [
                    'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8"><div class="form-group"><label>Title</label><input type="text" class="form-control" name="new_title_' . $no . '"></div></div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="new_content_' . $no . '"></textarea>
                </div>
                <div class="form-group">
                    *Press "Enter" to separate the tag<br>
                    <label>Tag</label>
                    <input type="text" class="form-control tagsinput" data-role="tagsinput" name="new_tag_' . $no . '">
                </div>
            </div>
        </div>';
        return $output;
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentMediaStatementTranslation::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
