<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentDownloads\models\ContentDownloads */

$this->title = $model->download_id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Content Downloads'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="content-downloads-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->download_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->download_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'download_id',
            'download_main',
            'download_parent_id',
            'download_language',
            'download_category',
            'download_type',
            'download_status',
            'download_portal_display',
            'download_source',
            'download_start_date',
            'download_start_time',
            'download_end_date',
            'download_end_time',
            'download_title',
            'download_img',
            'download_file',
            'created_at',
            'created_by',
            'updated_at',
            'updated_by',
        ],
    ]) ?>

</div>
