<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentDownloads\models\ContentDownloads;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentDownloads\models\ContentDownloadsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Documents');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Document'), ['create'], ['class' => 'btn btn-primary']) ?>
    </p>
    <div class="ibox animated fadeInRightx">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'layout' => "{summary}\n{items}\n<div align='center'>{pager}</div>",
                'tableOptions' => ['class' => 'table table-hover table-mail table-custom',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'header' => 'Image Preview',
                        'filter' => false,
                        'format' => 'raw',
                        'value' => function ($model) {
                            return '<img style="width:100px;border:1px solid #ccc;" src="../../../' . $model->download_img . '"/>';
                        }
                    ],
                    'download_title',
//                    [
//                        'headerOptions' => ['style' => 'width:10%'],
//                        'format' => 'raw',
//                        'attribute' => 'download_portal_display',
//                        'filter' => \backend\modules\refdynawebv2\models\Ref::getbranchlist(),
//                        'value' => function ($model) {
//                            $output = '';
//                            if (!empty($model->download_portal_display)) {
//                                $portal_arr = json_decode($model->download_portal_display);
//                                if (!empty($portal_arr)) {
//                                    foreach ($portal_arr as $portal_code) {
//
//                                        $ref = (new \yii\db\Query())->select(['descr'])
//                                                ->from('ref')
//                                                ->where(['=', 'cat', 'PORTAL'])
//                                                ->andwhere(['=', 'code', $portal_code])
//                                                ->one();
//                                        if (!empty($ref))
//                                            $output .= '<span class="label label-warning" style="display:block;margin-bottom:0.5em;white-space:normal;">' . $ref['descr'] . '</span>';
//                                    }
//                                }
//                            }
//                            return $output;
//                        }
//                    ],
                    [
                        'attribute' => 'download_status',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'CONTENT_STATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_STATUS'])
                                    ->andwhere(['=', 'code', $model->download_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'download_category',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr_en'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOWNLOAD_CATEGORY'])
                                        ->orderBy(['descr_en' => SORT_ASC])
                                        ->all(), 'code', 'descr_en'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr_en'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOWNLOAD_CATEGORY'])
                                    ->andwhere(['=', 'code', $model->download_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr_en'];
                        }
                    ],
                    [
                        'attribute' => 'download_type',
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr_en'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'DOWNLOAD_TYPE'])
                                        ->orderBy(['descr_en' => SORT_ASC])
                                        ->all(), 'code', 'descr_en'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr_en'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'DOWNLOAD_TYPE'])
                                    ->andwhere(['=', 'code', $model->download_type])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr_en'];
                        }
                    ],
                    [
                        'header' => 'Language',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_downloads')
                                                    ->orderBy(['download_language' => SORT_ASC])
                                                    ->groupby(['download_language'])
                                                    ->all(), 'download_language', 'download_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';

                                        if ($model->download_language == $code)
                                            $label_class = 'label-primary';

                                        if (($modeltranslation = ContentDownloads::findOne([
                                                    'download_parent_id' => $model->download_id,
                                                    'download_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output . Html::a('<i class="fa fa-plus" aria-hidden="true"></i>', ['addtranslation', 'id' => $model->download_id], ['class' => 'label label-danger']);
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{graph}&nbsp;&nbsp;{update}&nbsp;&nbsp;{delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                        'buttons' => [
                            'graph' => function($url, $model, $key) {
                                return Html::a('<span class="fa fa-line-chart"></span>', [
                                            '/pageVisitLog/page-visit-log/document-details',
                                            'id' => $model->download_id], ['target' => '_blank', 'title' => 'Page Views Statistics']);
                            },
                        ],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>