<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\contentDownloads\models\ContentDownloads;

$this->params['extra-asset']['CSS'][] = 'plugins/select2/select2.min.css';
$this->params['extra-asset']['JS'][] = 'plugins/select2/select2.full.min.js';

$this->registerJs(
        <<<JS
    $('.select2').select2({width:'100%'});
    $('.datepicker').datepicker({format: 'yyyy-mm-dd',autoclose: true,});
    $('.clockpicker').clockpicker({placement: 'top',align: 'left',autoclose: true, }); 
JS
);
?>
<style>
    .clearbtn{
        position:absolute;
        top:44%;
        right:10%;
        cursor:pointer;
    }
    .select2-container--default .select2-selection--single{border-radius: 0 !important;}
    .select2-container .select2-selection--single{height: 34px !important;}
    .select2-container--default .select2-selection--single .select2-selection__rendered {line-height: 34px !important;}
    #contentdownloads-download_portal_display label{
        font-weight:normal;
        margin-right:1em;
        width:23%;
        float:left;
        min-height:60px;
        border:1px solid #ccc;
        padding:0.5em;
        margin-right:2%;
    }
    .field-contentdownloads-download_portal_display{
        overflow: hidden;
        margin-bottom:1em;
    }
    .datepicker{border-radius: 0;}
</style>
<script>
    function cleardate(id) {
        $('#' + id).val('');
        $('#' + id).datepicker('setDate', null);
    }
    function cleartime(id) {
        $('#' + id).val('');
    }
</script>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <!--    <div class="ibox float-e-margins">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-12">
    <?php
//                    $form->field($model, 'download_portal_display')->checkboxList(\backend\modules\refdynawebv2\models\Ref::getbranchlist());
    ?>
                    </div>
                </div>
            </div></div>-->

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'download_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_STATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'class' => 'select2', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'download_type')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr_en'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOWNLOAD_TYPE'])
                                            ->orderBy(['descr_en' => SORT_ASC])
                                            ->all(), 'code', 'descr_en'), [
                        'class' => 'select2', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-3"><?= $form->field($model, 'doc_date')->textInput(['readonly' => false, 'autocomplete' => 'off', 'class' => 'form-control datepicker']) ?></div>

                <div class="col-sm-6">
                    <?=
                    $form->field($model, 'download_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr_en'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'DOWNLOAD_CATEGORY'])
                                            ->orderBy(['descr_en' => SORT_ASC])
                                            ->all(), 'code', 'descr_en'), [
                        'class' => 'select2', 'prompt' => '-- Please choose --'])
                    ?>
                </div>

                <div class="col-sm-6"><?= $form->field($model, 'download_source')->textInput() ?></div>

                <!--                <div class="col-sm-3">
                <?php //$form->field($model, 'download_source')->dropdownList(ArrayHelper::map(\backend\modules\refdynawebv2\models\Ref::find()->where(['cat' => 'CONTENT_SOURCE'])->orderBy(['descr_en' => SORT_ASC])->all(), 'code', 'descr_en'), ['maxlength' => true, 'prompt' => '- Please choose - ', 'class' => 'select2']) ?>
                                </div>-->
            </div>
            <!--            <div class="row">
                            <div class="col-sm-3">
            <?php //= $form->field($model, 'download_start_date')->textInput(['class' => 'form-control datepicker', 'readonly' => true]) ?>
                                <span onclick="cleardate('contentdownloads-download_start_date')" class="clearbtn">Clear</span>
                            </div>
                            <div class="col-sm-3">
            <?php //= $form->field($model, 'download_start_time')->textInput(['class' => 'form-control clockpicker', 'readonly' => true]) ?>
                                <span onclick="cleartime('contentdownloads-download_start_time')" class="clearbtn">Clear</span>
                            </div>
                            <div class="col-sm-3">
            <?php //= $form->field($model, 'download_end_date')->textInput(['class' => 'form-control datepicker', 'readonly' => true]) ?>
                                <span onclick="cleardate('contentdownloads-download_end_date')" class="clearbtn">Clear</span>
                            </div>
                            <div class="col-sm-3">
            <?php //= $form->field($model, 'download_end_time')->textInput(['class' => 'form-control clockpicker', 'readonly' => true]) ?>
                                <span onclick="cleartime('contentdownloads-download_end_time')" class="clearbtn">Clear</span>
                            </div>
                        </div>-->

            <div class="row">
                <div class="col-sm-3">
                    <?=
                    $form->field($model, 'download_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                            ->orderBy(['descr' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-9">
                    <?= $form->field($model, 'download_title')->textInput(['maxlength' => true]) ?>
                </div>
            </div>
            <?php
            if (!empty($model->download_img)) {
                echo $form->field($model, 'download_img')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '',
                        'browseLabel' => 'Select Image',
                        'initialPreviewAsData' => true,
                        'initialPreview' => ['../../../' . $model->download_img,],
                    ],
                ]);
            } else {
                echo $form->field($model, 'download_img')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '',
                        'browseLabel' => 'Select Image'
                    ],
                ]);
            }

            echo $form->field($model, 'download_file')->widget(FileInput::classname(), [
                'pluginOptions' => [
                    'showUpload' => false,
                    'showCaption' => false,
                    'showRemove' => false,
                    'showUpload' => false,
                    'browseClass' => 'btn btn-warning btn-block',
                    'browseIcon' => '',
                    'browseLabel' => 'Select File'
                ],
            ]);
            if (!empty($model->download_file))
                echo Html::a('Click here to view current file', ['../../../' . $model->download_file], ['target' => '_blank']);
            ?>
        </div>
    </div>


    <?php
    $modeltranslation = ContentDownloads::find()->where(['=', 'download_parent_id', $model->download_id])->orderBy(['download_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->download_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->download_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->download_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Downloads Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->download_id, $rowtranslation->download_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'CONTENT_LANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->download_id . '" value="' . $rowtranslation->download_title . '">
                        </div>
                    </div>
                </div>';

            if (!empty($rowtranslation->download_img)) {
                echo FileInput::widget([
                    'name' => 'old_img_' . $rowtranslation->download_id,
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '',
                        'browseLabel' => 'Select Image',
                        'initialPreviewAsData' => true,
                        'initialPreview' => ['../../../' . $rowtranslation->download_img,],
                    ],
                ]);
            } else {
                echo FileInput::widget([
                    'name' => 'old_img_' . $rowtranslation->download_id,
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '',
                        'browseLabel' => 'Select Image',
                    ],
                ]);
            }

            echo FileInput::widget([
                'name' => 'old_file_' . $rowtranslation->download_id,
                'pluginOptions' => [
                    'showUpload' => false,
                    'showCaption' => false,
                    'showRemove' => false,
                    'showUpload' => false,
                    'browseClass' => 'btn btn-warning btn-block',
                    'browseIcon' => '',
                    'browseLabel' => 'Select File',
                ],
            ]);
            if (!empty($rowtranslation->download_file))
                echo Html::a('Click here to view current file', ['../../../' . $rowtranslation->download_file], ['target' => '_blank']);


            echo '
            </div>
        </div>';
        }
    }
    ?>

    <div class="ibox float-e-margins">
        <div class="ibox-title"><h3>Metadata <span style="font-weight:normal;">(This data will be use for sharing to social media)</span></h3></div>
        <div class="ibox-content">
            <?= $form->field($model, 'meta_title')->textInput() ?>
            <?= $form->field($model, 'meta_author')->textInput() ?>
            <?= $form->field($model, 'meta_descr')->textarea(['rows' => '6']); ?>
            <?= $form->field($model, 'meta_keyword')->textarea(['rows' => '6']); ?>
            <?php
            if (!empty($model->meta_img)) {
                echo $form->field($model, 'meta_img')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '',
                        'browseLabel' => 'Select Image',
                        'initialPreviewAsData' => true,
                        'initialPreview' => ['../../../' . $model->meta_img,],
                    ],
                ]);
            } else {
                echo $form->field($model, 'meta_img')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'showCaption' => false,
                        'showRemove' => false,
                        'showUpload' => false,
                        'browseClass' => 'btn btn-warning btn-block',
                        'browseIcon' => '',
                        'browseLabel' => 'Select Image'
                    ],
                ]);
            }
            ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::a(Yii::t('app', 'Back'), ['index'], ['class' => 'btn btn-primary']) ?>
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

</div>
<?php ActiveForm::end(); ?>
<script>
    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>
