<?php

namespace backend\modules\contentDownloads\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentDownloads\models\ContentDownloads;

/**
 * ContentDownloadsSearch represents the model behind the search form of `backend\modules\contentDownloads\models\ContentDownloads`.
 */
class ContentDownloadsSearch extends ContentDownloads {

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['download_id'], 'integer'],
            [['download_main', 'download_parent_id', 'download_language', 'download_category', 'download_type', 'download_status', 'download_portal_display', 'download_source', 'download_start_date', 'download_start_time', 'download_end_date', 'download_end_time', 'download_title', 'download_img', 'download_file', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentDownloads::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['download_id' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andwhere(['=', 'download_main', 1]);
        $query->andFilterWhere(['like', 'download_title', $this->download_title]);
        $query->andFilterWhere(['like', 'download_status', $this->download_status]);
        $query->andFilterWhere(['like', 'download_category', $this->download_category]);
        $query->andFilterWhere(['like', 'download_type', $this->download_type]);

        if (!empty($this->download_portal_display))
            $query->andFilterWhere(['LIKE', 'download_portal_display', '"' . $this->download_portal_display . '"']);

        return $dataProvider;
    }

}
