<?php

namespace backend\modules\contentDownloads\models;

use Yii;
use yii\behaviors\TimestampBehavior;
use yii\behaviors\BlameableBehavior;
use yii\db\Expression;
use yii\db\ActiveRecord;
use asinfotrack\yii2\audittrail\behaviors\AuditTrailBehavior;

/**
 * This is the model class for table "content_downloads".
 *
 * @property int $download_id
 * @property string|null $download_main
 * @property string|null $download_parent_id
 * @property string|null $download_language
 * @property string|null $download_category
 * @property string|null $download_type
 * @property string|null $download_status
 * @property string|null $download_portal_display
 * @property string|null $download_source
 * @property string|null $download_start_date
 * @property string|null $download_start_time
 * @property string|null $download_end_date
 * @property string|null $download_end_time
 * @property string|null $download_title
 * @property string|null $download_img
 * @property string|null $download_file
 * @property string|null $created_at
 * @property string|null $created_by
 * @property string|null $updated_at
 * @property string $updated_by
 */
class ContentDownloads extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_downloads';
    }

    public function behaviors() {
        return [
            'audittrail' => [
                'class' => AuditTrailBehavior::className(),
                // some of the optional configurations
                'ignoredAttributes' => ['created_at', 'updated_at'],
                'consoleUserId' => 1,
                'attributeOutput' => [
                    'desktop_id' => function ($value) {
                        $model = Desktop::findOne($value);
                        return sprintf('%s %s', $model->manufacturer, $model->device_name);
                    },
                    'last_checked' => 'datetime',
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['download_main', 'download_parent_id', 'download_language', 'download_category', 'download_type', 'download_status', 
                'download_portal_display', 'download_source', 'download_start_date', 'download_start_time', 'download_end_date', 
                'download_end_time', 'download_title', 'download_img', 'download_file', 'created_by', 'updated_by', 'created_at', 'updated_at',
                'meta_title', 'meta_descr', 'meta_keyword', 'meta_author', 'meta_img'], 'safe'],
            [['download_status', 'download_category', 'download_type', 'download_title', 'download_language', 'doc_date'], 'required'],
            [['download_img', 'download_file'], 'required', 'on' => 'create']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'download_id' => Yii::t('app', 'Download ID'),
            'download_main' => Yii::t('app', 'Download Main'),
            'download_parent_id' => Yii::t('app', 'Download Parent ID'),
            'download_language' => Yii::t('app', 'Language'),
            'download_category' => Yii::t('app', 'Category'),
            'download_type' => Yii::t('app', 'Type'),
            'download_status' => Yii::t('app', 'Status'),
            'download_portal_display' => Yii::t('app', 'Portal Display'),
            'download_source' => Yii::t('app', 'Source'),
            'download_start_date' => Yii::t('app', 'Publish Start Date'),
            'download_start_time' => Yii::t('app', 'Publish Start Time'),
            'download_end_date' => Yii::t('app', 'Publish End Date'),
            'download_end_time' => Yii::t('app', 'Publish End Time'),
            'download_title' => Yii::t('app', 'Title'),
            'download_img' => Yii::t('app', 'Image Preview'),
            'download_file' => Yii::t('app', 'File Download'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'doc_date' => 'Document Date',
            'meta_title' => 'Meta Title',
            'meta_descr' => 'Meta Description',
            'meta_keyword' => 'Meta Keywords',
            'meta_author' => 'Author',
            'meta_img' => 'Image Thumbnail'
        ];
    }

}
