<?php

namespace backend\modules\contentDownloads\controllers;

use Yii;
use backend\modules\contentDownloads\models\ContentDownloads;
use backend\modules\contentDownloads\models\ContentDownloadsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

/**
 * ContentDownloadsController implements the CRUD actions for ContentDownloads model.
 */
class ContentDownloadsController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentDownloads models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentDownloadsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentDownloads model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentDownloads model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentDownloads();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->download_main = 1;
        $model->download_language = 'English';
        $model->scenario = 'create';
        if ($model->load(Yii::$app->request->post())) {
            
            $model->meta_img = UploadedFile::getInstance($model, 'meta_img');
            if (!empty($model->meta_img)) {
                $meta_img = 'uploads/metadata/' . date("YmdHis") . '.' . $model->meta_img->extension;
                if ($model->meta_img->saveAs('../' . $meta_img))
                    $model->meta_img = $meta_img;
            }
            
            if (!empty($model->download_portal_display))
                $model->download_portal_display = json_encode($model->download_portal_display);

            $model->download_img = UploadedFile::getInstance($model, 'download_img');
            if (!empty($model->download_img)) {
                $download_img = 'uploads/content-downloads/img_' . date("YmdHis") . '.' . $model->download_img->extension;
                if ($model->download_img->saveAs('../' . $download_img))
                    $model->download_img = $download_img;
            }

            $model->download_file = UploadedFile::getInstance($model, 'download_file');
            if (!empty($model->download_file)) {
                $download_file = 'uploads/content-downloads/file_' . date("YmdHis") . '.' . $model->download_file->extension;
                if ($model->download_file->saveAs('../' . $download_file))
                    $model->download_file = $download_file;
            }

            if ($model->save())
                return $this->redirect(['index']);
        }

        return $this->render('create', ['model' => $model,]);
    }

    /**
     * Updates an existing ContentDownloads model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $original_meta_img = $model->meta_img;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        if (!empty($model->download_portal_display))
            $model->download_portal_display = json_decode($model->download_portal_display);

        $original_download_img = $model->download_img;
        $original_download_file = $model->download_file;

        if ($model->load(Yii::$app->request->post())) {
            
            $model->meta_img = UploadedFile::getInstance($model, 'meta_img');
            if (!empty($model->meta_img)) {
                $meta_img = 'uploads/metadata/' . date("YmdHis") . '.' . $model->meta_img->extension;
                if ($model->meta_img->saveAs('../' . $meta_img))
                    $model->meta_img = $meta_img;
            } else {
                $model->meta_img = $original_meta_img;
            }
            
            if (!empty($model->download_portal_display))
                $model->download_portal_display = json_encode($model->download_portal_display);

            $model->download_img = UploadedFile::getInstance($model, 'download_img');
            if (!empty($model->download_img)) {
                $download_img = 'uploads/content-downloads/img_' . date("YmdHis") . '.' . $model->download_img->extension;
                if ($model->download_img->saveAs('../' . $download_img))
                    $model->download_img = $download_img;
            } else {
                $model->download_img = $original_download_img;
            }

            $model->download_file = UploadedFile::getInstance($model, 'download_file');
            if (!empty($model->download_file)) {
                $download_file = 'uploads/content-downloads/file_' . date("YmdHis") . '.' . $model->download_file->extension;
                if ($model->download_file->saveAs('../' . $download_file))
                    $model->download_file = $download_file;
            } else {
                $model->download_file = $original_download_file;
            }

            $count_img = 0;
            if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                foreach ($_POST['oldtranslation'] as $oldtranslation) {
                    if (($modeltranslationupdate = ContentDownloads::findOne($oldtranslation)) !== null) {
                        $count_img++;

                        $download_translation_img = UploadedFile::getInstanceByName('old_img_' . $oldtranslation);
                        if (!empty($download_translation_img)) {
                            $download_translation_img_name = 'uploads/content-downloads/img_' . date("YmdHis") . '_' . $count_img . '.' . $download_translation_img->extension;
                            if ($download_translation_img->saveAs('../' . $download_translation_img_name))
                                $modeltranslationupdate->download_img = $download_translation_img_name;
                        }
                        
                        $download_translation_file = UploadedFile::getInstanceByName('old_file_' . $oldtranslation);
                        if (!empty($download_translation_file)) {
                            $download_translation_file_name = 'uploads/content-downloads/file_' . date("YmdHis") . '_' . $count_img . '.' . $download_translation_file->extension;
                            if ($download_translation_file->saveAs('../' . $download_translation_file_name))
                                $modeltranslationupdate->download_file = $download_translation_file_name;
                        }

                        $modeltranslationupdate->download_title = $_POST['old_title_' . $oldtranslation];
                        $modeltranslationupdate->download_language = $_POST['old_language_' . $oldtranslation];
                        $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                        $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                        $modeltranslationupdate->save(false);
                    }
                }
            }


            if ($model->save())
                return $this->redirect(['index']);
        }

        return $this->render('update', [
                    'model' => $model,
        ]);
    }

    /**
     * Deletes an existing ContentDownloads model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentDownloads::deleteAll(['download_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentDownloads model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentDownloads the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentDownloads::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionAddtranslation($id) {
        $modeltranslation = new ContentDownloads();
        $modeltranslation->download_parent_id = $id;
        $modeltranslation->download_main = 0;
        $modeltranslation->created_at = date("Y-m-d H:i:s");
        $modeltranslation->created_by = Yii::$app->user->identity->id;
        $modeltranslation->updated_at = date("Y-m-d H:i:s");
        $modeltranslation->updated_by = Yii::$app->user->identity->id;
        $modeltranslation->save(false);
        return $this->redirect(['update', 'id' => $id]);
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentDownloads::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
