<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use backend\modules\contentArticle\models\ContentArticleTranslation;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\contentArticle\models\ContentArticleSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Article');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wrapper wrapper-content">
    <p>
        <?= Html::a(Yii::t('app', 'Create Article'), ['create'], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'API Article List'), ['/api/api/view?api_code=ContentArticleList'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
        <?= Html::a(Yii::t('app', 'API Article Details'), ['/api/api/view?api_code=ContentArticleDetails'], ['class' => 'btn btn-primary', 'target' => '_blank']) ?>
    </p>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="ibox animated fadeInRight">
        <div class="mail-box b-r-md">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table',],
                'summary' => '',
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    [
                        'attribute' => 'article_title',
                        'value' => function ($model) {
                            if (($modeltranslation = ContentArticleTranslation::findOne(['article_translation_parent_id' => $model->article_id, 'article_translation_main' => 1])) !== null) {
                                return $modeltranslation->article_translation_title;
                            }
                        }
                    ],
                    [
                        'attribute' => 'article_portal_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLEPORTAL'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLEPORTAL'])
                                    ->andwhere(['=', 'code', $model->article_portal_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'article_category',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLECATEGORY'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLECATEGORY'])
                                    ->andwhere(['=', 'code', $model->article_category])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ], [
                        'attribute' => 'article_status',
                        'headerOptions' => ['style' => 'width:10%'],
                        'filter' => ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ARTICLESTATUS'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'),
                        'value' => function ($model) {
                            $ref = (new \yii\db\Query())->select(['descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLESTATUS'])
                                    ->andwhere(['=', 'code', $model->article_status])
                                    ->one();
                            if (!empty($ref))
                                return $ref['descr'];
                        }
                    ],
                    [
                        'attribute' => 'article_date',
                        'headerOptions' => ['style' => 'width:10%'],
                    ], [
                        'header' => 'Language',
                        'format' => 'raw',
                        'headerOptions' => ['style' => 'width:10%'],
                        'value' => function ($model) {
                            $output = '';
                            $arr = ArrayHelper::map(
                                            (new \yii\db\Query())->select(['*'])
                                                    ->from('content_article_translation')
                                                    ->orderBy(['article_translation_language' => SORT_ASC])
                                                    ->groupby(['article_translation_language'])
                                                    ->all(), 'article_translation_language', 'article_translation_language');
                            if (!empty($arr)) {
                                foreach ($arr as $code) {
                                    $ref = (new \yii\db\Query())->select(['descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLELANGUAGE'])
                                            ->andwhere(['=', 'code', $code])
                                            ->one();
                                    if (!empty($ref)) {
                                        $label_class = 'label-dark';
                                        if (($modeltranslation = ContentArticleTranslation::findOne(['article_translation_parent_id' => $model->article_id, 'article_translation_language' => $code])) !== null) {
                                            $label_class = 'label-primary';
                                        }
                                        $output .= '<span class="label ' . $label_class . '">' . $ref['descr'] . '</span>&nbsp;&nbsp;';
                                    }
                                }
                            }
                            return $output;
                        }
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'header' => 'Action',
                        'template' => '{update} {delete}',
                        'headerOptions' => ['style' => 'text-align:center;width:10%'],
                        'contentOptions' => ['style' => 'text-align:center;'],
                    ],
                ],
            ]);
            ?>
        </div>
    </div>
</div>
