<?php

use mihaildev\ckeditor\CKEditor;
use mihaildev\elfinder\ElFinder;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use backend\modules\contentArticle\models\ContentArticleTranslation;

/* @var $this yii\web\View */
/* @var $model backend\modules\contentArticle\models\ContentArticle */
/* @var $form yii\widgets\ActiveForm */
$this->registerCssFile('@web/plugins/summernote/summernote.min.css');
$this->registerJsFile('@web/plugins/summernote/summernote.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);
$this->registerCssFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css');
$this->registerJsFile('@web/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js', ['depends' => [\yii\web\JqueryAsset::className()]]);

$this->registerJs(
        <<<JS
    $('#contentarticle-article_date').datepicker({'format':'yyyy-mm-dd'});
    $('.summernote').summernote({height: 300});
    $('#w0').on('keyup keypress', function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13) { 
          e.preventDefault();
          return false;
        }
      });
JS
);
$this->registerCss(".note-editor{border:1px solid #e5e6e7 !important}
    .bootstrap-tagsinput input, .bootstrap-tagsinput {width:100% !important;}");
?>
<?php $form = ActiveForm::begin(); ?>
<div class="wrapper wrapper-content animated fadeInRight" style="padding: 20px 10px 20px;">
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'article_portal_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLEPORTAL'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'article_category')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLECATEGORY'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'onchange' => 'changecategory(this.value)', 'prompt' => '-- Please choose --'])
                    ?>
                </div>
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'article_subcategory')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLESUBCATEGORY'])
                                            ->andwhere(['=', 'param1', $model->article_category])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true, 'prompt' => '-- Please choose --'])
                    ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'article_status')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLESTATUS'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-4"><?= $form->field($model, 'article_date')->textInput() ?></div>

                <div class="col-sm-4"><?= $form->field($model, 'article_sorting')->textInput() ?></div>
                <div class="col-sm-12"><?= $form->field($model, 'article_url')->textInput(['maxlength' => true]) ?></div>
            </div>
            <?php
            $img_url = Yii::getAlias('@web') . '/images/noimage.jpg';
            if (!empty($model->article_image)) {
                echo $form->field($model, 'article_image')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                    'pluginOptions' => [
                        'showUpload' => false,
                        'initialPreview' => [
                            '<img style="width:100%" src="' . Yii::getAlias('@web') . '/' . $model->article_image . '"/>',
                        ],
                    ]
                ]);
            } else {
                echo $form->field($model, 'article_image')->widget(FileInput::classname(), [
                    'options' => ['accept' => 'image/*'],
                ]);
            }
            ?>
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div class="row">
                <div class="col-sm-4">
                    <?=
                    $form->field($model, 'article_language')->dropdownList(
                            ArrayHelper::map(
                                    (new \yii\db\Query())->select(['code', 'descr'])
                                            ->from('ref')
                                            ->where(['=', 'cat', 'ARTICLELANGUAGE'])
                                            ->orderBy(['sort' => SORT_ASC])
                                            ->all(), 'code', 'descr'), [
                        'maxlength' => true,])
                    ?>
                </div>
                <div class="col-sm-8"><?= $form->field($model, 'article_title')->textInput() ?></div>
            </div>


            <?= $form->field($model, 'article_content')->textarea(['class' => 'summernote']) ?>
            *Press "Enter" to separate the tag
            <?= $form->field($model, 'article_tag')->textInput(['maxlength' => true, 'data-role' => 'tagsinput']) ?>
        </div> 
    </div>
    <?php
    $modeltranslation = ContentArticleTranslation::find()
                    ->where(['=', 'article_translation_parent_id', $model->article_id])
                    ->andwhere(['=', 'article_translation_main', '0'])
                    ->orderBy(['article_translation_id' => SORT_ASC])->all();
    if (!empty($modeltranslation)) {
        foreach ($modeltranslation as $rowtranslation) {
            echo '<div class="ibox float-e-margins" id="old-translation-' . $rowtranslation->article_translation_id . '">
            <input type="hidden" name="oldtranslation[]" value="' . $rowtranslation->article_translation_id . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deleteoldtranslation(' . $rowtranslation->article_translation_id . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                Article Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('old_language_' . $rowtranslation->article_translation_id, $rowtranslation->article_translation_language, ArrayHelper::map(
                            (new \yii\db\Query())->select(['code', 'descr'])
                                    ->from('ref')
                                    ->where(['=', 'cat', 'ARTICLELANGUAGE'])
                                    ->orderBy(['sort' => SORT_ASC])
                                    ->all(), 'code', 'descr'), [
                'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" class="form-control" name="old_title_' . $rowtranslation->article_translation_id . '" value="' . $rowtranslation->article_translation_title . '">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="old_content_' . $rowtranslation->article_translation_id . '">' . $rowtranslation->article_translation_content . '</textarea>
                </div>
                <div class="form-group">
                    *Press "Enter" to separate the tag<br>
                    <label>Tag</label>
                    <input type="text" class="form-control tagsinput" data-role="tagsinput" name="old_tag_' . $rowtranslation->article_translation_id . '" value="' . $rowtranslation->article_translation_tag . '">
                </div>
            </div>
        </div>';
        }
    }
    ?>
    <div id="wrapper-translation"></div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        <?php
        if (!$model->isNewRecord)
            echo Html::button('Add Translation', ['class' => 'btn btn-primary', 'onclick' => 'addtranslation()']);
        ?>
    </div>
</div>
<?php ActiveForm::end(); ?>
<script>
    function changecategory(parent_code) {
        $.ajax({
            url: "getsubcategory?parent_code=" + parent_code,
            method: "GET",
            success: function (response) {
                $('#contentarticle-article_subcategory').find('option').not(':first').remove();
                $('#contentarticle-article_subcategory').append(response);
            },
        });
    }

    var newcount = 1;
    function addtranslation() {
        newcount++;
        $.ajax({
            url: "addtranslation?no=" + newcount,
            method: "GET",
            success: function (response) {
                $('#wrapper-translation').append(response);
                $('.summernote').summernote({height: 300});
                $('.tagsinput').tagsinput('refresh');
            },
        });
    }

    function deletenewtranslation(no) {
        $('#new-translation-' + no).remove();
    }

    function deleteoldtranslation(id) {
        var r = confirm("Are you sure to delete this data?");
        if (r == true) {
            $.ajax({
                url: "deletetranslation?id=" + id,
                method: "GET",
                success: function (response) {
                    $('#old-translation-' + id).remove();
                },
            });
        }
    }
</script>