<?php

namespace backend\modules\contentArticle\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentArticle\models\ContentArticleTranslation;

/**
 * ContentArticleTranslationSearch represents the model behind the search form of `backend\modules\contentArticle\models\ContentArticleTranslation`.
 */
class ContentArticleTranslationSearch extends ContentArticleTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['article_translation_id', 'article_translation_parent_id', 'created_by', 'updated_by'], 'integer'],
            [['article_translation_title', 'article_translation_content', 'article_translation_tag', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ContentArticleTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'article_translation_id' => $this->article_translation_id,
            'article_translation_parent_id' => $this->article_translation_parent_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'article_translation_title', $this->article_translation_title])
            ->andFilterWhere(['like', 'article_translation_content', $this->article_translation_content])
            ->andFilterWhere(['like', 'article_translation_tag', $this->article_translation_tag]);

        return $dataProvider;
    }
}
