<?php

namespace backend\modules\contentArticle\models;

use Yii;

/**
 * This is the model class for table "content_article_translation".
 *
 * @property int $article_translation_id
 * @property int|null $article_translation_parent_id
 * @property string|null $article_translation_title
 * @property string|null $article_translation_content
 * @property string|null $article_translation_tag
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentArticleTranslation extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_article_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['article_translation_parent_id', 'created_by', 'updated_by', 'article_translation_main'], 'integer'],
            [['article_translation_title', 'article_translation_content', 'article_translation_tag'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'article_translation_id' => Yii::t('app', 'Article Translation ID'),
            'article_translation_parent_id' => Yii::t('app', 'Article Translation Parent ID'),
            'article_translation_title' => Yii::t('app', 'Article Translation Title'),
            'article_translation_content' => Yii::t('app', 'Article Translation Content'),
            'article_translation_tag' => Yii::t('app', 'Article Translation Tag'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
