<?php

namespace backend\modules\contentArticle\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentArticle\models\ContentArticle;

/**
 * ContentArticleSearch represents the model behind the search form of `backend\modules\contentArticle\models\ContentArticle`.
 */
class ContentArticleSearch extends ContentArticle {

    public $article_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['article_id', 'article_sorting', 'created_by', 'updated_by'], 'integer'],
            [['article_date', 'article_category', 'article_status', 'article_url', 'article_image', 'article_portal_category', 'created_at', 'updated_at', 'article_title'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentArticle::find()
                ->innerJoin('content_article_translation', 'content_article_translation.article_translation_parent_id=content_article.article_id')
                ->where(['=', 'content_article_translation.article_translation_main', '1']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['LIKE', 'article_date', $this->article_date]);
        $query->andFilterWhere(['=', 'article_category', $this->article_category]);
        $query->andFilterWhere(['=', 'article_status', $this->article_status]);
        $query->andFilterWhere(['LIKE', 'article_translation_title', $this->article_title]);


        return $dataProvider;
    }

}
