<?php

namespace backend\modules\contentArticle\models;

use Yii;

/**
 * This is the model class for table "content_article".
 *
 * @property int $article_id
 * @property string|null $article_date
 * @property string|null $article_category
 * @property string|null $article_status
 * @property string|null $article_url
 * @property int|null $article_sorting
 * @property string|null $article_image
 * @property string|null $article_portal_category
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentArticle extends \yii\db\ActiveRecord {

    public $article_title;
    public $article_tag;
    public $article_content;
    public $article_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_article';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['article_title', 'article_content', 'article_language','article_category'], 'required'],
            [['article_date', 'created_at', 'updated_at', 'article_subcategory', 'article_tag'], 'safe'],
            [['article_sorting', 'created_by', 'updated_by'], 'integer'],
            [['article_category', 'article_status', 'article_url', 'article_image', 'article_portal_category'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'article_id' => Yii::t('app', 'Article ID'),
            'article_date' => Yii::t('app', 'Article Date'),
            'article_category' => Yii::t('app', 'Category'),
            'article_subcategory' => Yii::t('app', 'Subcategory'),
            'article_status' => Yii::t('app', 'Status'),
            'article_url' => Yii::t('app', 'URL Related'),
            'article_sorting' => Yii::t('app', 'Sorting'),
            'article_image' => Yii::t('app', 'Thumbnail'),
            'article_portal_category' => Yii::t('app', 'Portal Category'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'article_title' => Yii::t('app', 'Title'),
            'article_content' => Yii::t('app', 'Content'),
            'article_language' => Yii::t('app', 'Language'),
            'article_tag' => Yii::t('app', 'Tag'),
        ];
    }

}
