CREATE TABLE IF NOT EXISTS `content_announcement` (
  `announcement_id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement_date` date DEFAULT NULL,
  `announcement_category` varchar(255) DEFAULT NULL,
  `announcement_subcategory` varchar(255) DEFAULT NULL,
  `announcement_status` varchar(255) DEFAULT NULL,
  `announcement_url` varchar(255) DEFAULT NULL,
  `announcement_sorting` int(11) DEFAULT '0' NULL,
  `announcement_image` varchar(255) DEFAULT NULL,
  `announcement_portal_category` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `content_announcement_translation` (
  `announcement_translation_id` int(11) NOT NULL AUTO_INCREMENT,
  `announcement_translation_parent_id` int(11) DEFAULT NULL,
  `announcement_translation_title` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `announcement_translation_content` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `announcement_translation_tag` text CHARACTER SET utf8mb4 DEFAULT NULL,
  `announcement_translation_main` int(11) DEFAULT NULL,
  `announcement_translation_language` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`announcement_translation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr_en` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `param1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_by` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `deleted_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

insert  into `ref`(`cat`,`code`,`descr`,`descr_en`,`sort`,`param1`,`icon_name`,`created_by`,`created_at`,`updated_by`,`updated_at`,`deleted_at`) values 
('ANNOUNCEMENTSTATUS','active','Active',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTSTATUS','inactive','Inactive',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTSTATUS','archived','Archived',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTPORTAL','portal01','Homepage',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTCATEGORY','announcementcategory01','Main Announcement',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Malay','Malay',NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Chinese','Chinese',NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','English','English',NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Hindi','Hindi',NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Arabic','Arabic',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Japanese','Japanese',NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Tamil','Tamil',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('ANNOUNCEMENTLANGUAGE','Korean','Korean',NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

CREATE TABLE IF NOT EXISTS `api` (
  `api_id` int(11) NOT NULL AUTO_INCREMENT,
  `api_code` varchar(255) DEFAULT NULL,
  `api_descr` text DEFAULT NULL,
  `api_content` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`api_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

insert  into `api`(`api_code`,`api_descr`,`api_content`,`created_at`,`created_by`,`updated_at`,`updated_by`) values 
('ContentAnnouncementList','This is the API to display all the list of announcement','<?php \r\n\r\n$sql = \"SELECT * FROM content_announcement_translation t1 \r\n    INNER JOIN content_announcement t2 ON t1.announcement_translation_parent_id=t2.announcement_id\";\r\n$model = Yii::$app->db->createCommand($sql)->queryAll();\r\n$arr = [];\r\n$status = \'failed\';\r\nif(!empty($model)){\r\n    foreach($model as $row){\r\n        $status = \'success\';\r\n        $arr2 = [];\r\n        $arr2[\'language\'] = $row[\'announcement_translation_language\'];\r\n        $arr2[\'title\'] = $row[\'announcement_translation_title\'];\r\n        $arr2[\'content\'] = $row[\'announcement_translation_content\'];\r\n        $arr2[\'tag\'] = $row[\'announcement_translation_tag\'];\r\n        \r\n        $arr2[\'portal_category\'] = $row[\'announcement_portal_category\'];\r\n        $arr2[\'category\'] = $row[\'announcement_category\'];\r\n        $arr2[\'subcategory\'] = $row[\'announcement_subcategory\'];\r\n        $arr2[\'status\'] = $row[\'announcement_status\'];\r\n        $arr2[\'announcement_date\'] = $row[\'announcement_date\'];\r\n        $arr2[\'sorting\'] = $row[\'announcement_sorting\'];\r\n        $arr2[\'url_related\'] = $row[\'announcement_url\'];\r\n        $arr2[\'thumbnail\'] = $row[\'announcement_image\'];\r\n        \r\n        $arr[] = $arr2;\r\n    }\r\n}\r\necho json_encode([\'result_status\'=>$status,\'data\'=>$arr]);',NOW(),3,NOW(),3),
('ContentAnnouncementDetails','This is the API to display the details of the announcement','<?php \r\n$announcement_id = \'\';\r\n$arr = [];\r\n$status = \'failed\';\r\n$remark = \'\';\r\nif(isset($_GET[\'announcement_id\'])&&!empty($_GET[\'announcement_id\'])){\r\n    $announcement_id = $_GET[\'announcement_id\'];\r\n    $sql = \"SELECT * FROM content_announcement_translation t1 \r\n        INNER JOIN content_announcement t2 ON t1.announcement_translation_parent_id=t2.announcement_id WHERE t2.announcement_id=\".$announcement_id;\r\n    $model = Yii::$app->db->createCommand($sql)->queryAll();\r\n    \r\n    if(!empty($model)){\r\n        foreach($model as $row){\r\n            $status = \'success\';\r\n            $arr2 = [];\r\n            $arr2[\'language\'] = $row[\'announcement_translation_language\'];\r\n            $arr2[\'title\'] = $row[\'announcement_translation_title\'];\r\n            $arr2[\'content\'] = $row[\'announcement_translation_content\'];\r\n            $arr2[\'tag\'] = $row[\'announcement_translation_tag\'];\r\n            \r\n            $arr2[\'portal_category\'] = $row[\'announcement_portal_category\'];\r\n            $arr2[\'category\'] = $row[\'announcement_category\'];\r\n            $arr2[\'subcategory\'] = $row[\'announcement_subcategory\'];\r\n            $arr2[\'status\'] = $row[\'announcement_status\'];\r\n            $arr2[\'announcement_date\'] = $row[\'announcement_date\'];\r\n            $arr2[\'sorting\'] = $row[\'announcement_sorting\'];\r\n            $arr2[\'url_related\'] = $row[\'announcement_url\'];\r\n            $arr2[\'thumbnail\'] = $row[\'announcement_image\'];\r\n            \r\n            $arr[] = $arr2;\r\n        }\r\n    }else{\r\n        $remark = \'Record not found\';\r\n    }\r\n    \r\n}else{\r\n    $remark = \'Please specify the announcement_id using $_GET method\';\r\n}\r\necho json_encode([\'result_status\'=>$status,\'remark\'=>$remark,\'data\'=>$arr]);',NOW(),3,NOW(),3);

insert  into `backend_menu`(`menu_name`,`menu_param`,`menu_class`,`menu_link`,`menu_active_route`,`menu_parent_id`,`menu_status`) values 
('Announcement','','fa fa-bullhorn','/contentAnnouncement/content-announcement/index','',0,1);

insert  into `route`(`name`,`alias`,`type`,`status`) values ('/contentAnnouncement/content-announcement/index','index','contentAnnouncement/content-announcement',1);