<?php

namespace backend\modules\contentAnnouncement\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentAnnouncement\models\ContentAnnouncementTranslation;

/**
 * ContentAnnouncementTranslationSearch represents the model behind the search form of `backend\modules\contentAnnouncement\models\ContentAnnouncementTranslation`.
 */
class ContentAnnouncementTranslationSearch extends ContentAnnouncementTranslation
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['announcement_translation_id', 'announcement_translation_parent_id', 'created_by', 'updated_by'], 'integer'],
            [['announcement_translation_title', 'announcement_translation_content', 'announcement_translation_tag', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ContentAnnouncementTranslation::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'announcement_translation_id' => $this->announcement_translation_id,
            'announcement_translation_parent_id' => $this->announcement_translation_parent_id,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'announcement_translation_title', $this->announcement_translation_title])
            ->andFilterWhere(['like', 'announcement_translation_content', $this->announcement_translation_content])
            ->andFilterWhere(['like', 'announcement_translation_tag', $this->announcement_translation_tag]);

        return $dataProvider;
    }
}
