<?php

namespace backend\modules\contentAnnouncement\models;

use Yii;

/**
 * This is the model class for table "content_announcement_translation".
 *
 * @property int $announcement_translation_id
 * @property int|null $announcement_translation_parent_id
 * @property string|null $announcement_translation_title
 * @property string|null $announcement_translation_content
 * @property string|null $announcement_translation_tag
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentAnnouncementTranslation extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_announcement_translation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['announcement_translation_parent_id', 'created_by', 'updated_by', 'announcement_translation_main'], 'integer'],
            [['announcement_translation_title', 'announcement_translation_content', 'announcement_translation_tag'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'announcement_translation_id' => Yii::t('app', 'Announcement Translation ID'),
            'announcement_translation_parent_id' => Yii::t('app', 'Announcement Translation Parent ID'),
            'announcement_translation_title' => Yii::t('app', 'Announcement Translation Title'),
            'announcement_translation_content' => Yii::t('app', 'Announcement Translation Content'),
            'announcement_translation_tag' => Yii::t('app', 'Announcement Translation Tag'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
        ];
    }

}
