<?php

namespace backend\modules\contentAnnouncement\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\contentAnnouncement\models\ContentAnnouncement;

/**
 * ContentAnnouncementSearch represents the model behind the search form of `backend\modules\contentAnnouncement\models\ContentAnnouncement`.
 */
class ContentAnnouncementSearch extends ContentAnnouncement {

    public $announcement_title;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['announcement_id', 'announcement_sorting', 'created_by', 'updated_by'], 'integer'],
            [['announcement_date', 'announcement_category', 'announcement_status', 'announcement_url', 'announcement_image', 'announcement_portal_category', 'created_at', 'updated_at', 'announcement_title'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = ContentAnnouncement::find()
                ->innerJoin('content_announcement_translation', 'content_announcement_translation.announcement_translation_parent_id=content_announcement.announcement_id')
                ->where(['=', 'content_announcement_translation.announcement_translation_main', '1']);

        // add conditions that should always apply here
        $dataProvider = new ActiveDataProvider(['query' => $query, 'pagination' => ['pageSize' => 10,]]);
        $dataProvider->setSort(['defaultOrder' => ['updated_at' => SORT_DESC]]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere(['LIKE', 'announcement_date', $this->announcement_date]);
        $query->andFilterWhere(['=', 'announcement_category', $this->announcement_category]);
        $query->andFilterWhere(['=', 'announcement_status', $this->announcement_status]);
        $query->andFilterWhere(['LIKE', 'announcement_translation_title', $this->announcement_title]);


        return $dataProvider;
    }

}
