<?php

namespace backend\modules\contentAnnouncement\models;

use Yii;

/**
 * This is the model class for table "content_announcement".
 *
 * @property int $announcement_id
 * @property string|null $announcement_date
 * @property string|null $announcement_category
 * @property string|null $announcement_status
 * @property string|null $announcement_url
 * @property int|null $announcement_sorting
 * @property string|null $announcement_image
 * @property string|null $announcement_portal_category
 * @property string|null $created_at
 * @property int|null $created_by
 * @property string|null $updated_at
 * @property int|null $updated_by
 */
class ContentAnnouncement extends \yii\db\ActiveRecord {

    public $announcement_title;
    public $announcement_tag;
    public $announcement_content;
    public $announcement_language;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'content_announcement';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['announcement_title', 'announcement_content', 'announcement_language','announcement_category'], 'required'],
            [['announcement_date', 'created_at', 'updated_at', 'announcement_subcategory', 'announcement_tag'], 'safe'],
            [['announcement_sorting', 'created_by', 'updated_by'], 'integer'],
            [['announcement_category', 'announcement_status', 'announcement_url', 'announcement_image', 'announcement_portal_category'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'announcement_id' => Yii::t('app', 'Announcement ID'),
            'announcement_date' => Yii::t('app', 'Announcement Date'),
            'announcement_category' => Yii::t('app', 'Category'),
            'announcement_subcategory' => Yii::t('app', 'Subcategory'),
            'announcement_status' => Yii::t('app', 'Status'),
            'announcement_url' => Yii::t('app', 'URL Related'),
            'announcement_sorting' => Yii::t('app', 'Sorting'),
            'announcement_image' => Yii::t('app', 'Thumbnail'),
            'announcement_portal_category' => Yii::t('app', 'Portal Category'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'announcement_title' => Yii::t('app', 'Title'),
            'announcement_content' => Yii::t('app', 'Content'),
            'announcement_language' => Yii::t('app', 'Language'),
            'announcement_tag' => Yii::t('app', 'Tag'),
        ];
    }

}
