<?php

namespace backend\modules\contentAnnouncement\controllers;

use Yii;
use backend\modules\contentAnnouncement\models\ContentAnnouncement;
use backend\modules\contentAnnouncement\models\ContentAnnouncementTranslation;
use backend\modules\contentAnnouncement\models\ContentAnnouncementSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * ContentAnnouncementController implements the CRUD actions for ContentAnnouncement model.
 */
class ContentAnnouncementController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ContentAnnouncement models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new ContentAnnouncementSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ContentAnnouncement model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ContentAnnouncement model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new ContentAnnouncement();
        $model->created_at = date("Y-m-d H:i:s");
        $model->created_by = Yii::$app->user->identity->id;
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $model->announcement_language = 'Malay';
        if ($model->load(Yii::$app->request->post())) {
            $model->announcement_image = UploadedFile::getInstance($model, 'announcement_image');
            if (!empty($model->announcement_image)) {
                $announcement_image = 'images/modules/contentAnnouncement_' . date("YmdHis") . '.' . $model->announcement_image->extension;
                if ($model->announcement_image->saveAs($announcement_image))
                    $model->announcement_image = $announcement_image;
            }
            if ($model->save()) {

                $modeltranslation = new ContentAnnouncementTranslation();
                $modeltranslation->announcement_translation_parent_id = $model->announcement_id;
                $modeltranslation->announcement_translation_title = $model->announcement_title;
                $modeltranslation->announcement_translation_content = $model->announcement_content;
                $modeltranslation->announcement_translation_tag = $model->announcement_tag;
                $modeltranslation->announcement_translation_language = $model->announcement_language;
                $modeltranslation->announcement_translation_main = 1;
                $modeltranslation->created_at = date("Y-m-d H:i:s");
                $modeltranslation->created_by = Yii::$app->user->identity->id;
                $modeltranslation->updated_at = date("Y-m-d H:i:s");
                $modeltranslation->updated_by = Yii::$app->user->identity->id;
                $modeltranslation->save();

                return $this->redirect(['index']);
            }
        }
        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing ContentAnnouncement model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $model->updated_at = date("Y-m-d H:i:s");
        $model->updated_by = Yii::$app->user->identity->id;
        $original_thumbnail = $model->announcement_image;

        $translation_id = '';

        if (($modeltranslation = ContentAnnouncementTranslation::findOne(['announcement_translation_parent_id' => $model->announcement_id, 'announcement_translation_main' => 1])) !== null) {
            $translation_id = $modeltranslation->announcement_translation_id;
            $model->announcement_title = $modeltranslation->announcement_translation_title;
            $model->announcement_content = $modeltranslation->announcement_translation_content;
            $model->announcement_tag = $modeltranslation->announcement_translation_tag;
            $model->announcement_language = $modeltranslation->announcement_translation_language;
        }

        if ($model->load(Yii::$app->request->post())) {
            $model->announcement_image = UploadedFile::getInstance($model, 'announcement_image');
            if (!empty($model->announcement_image)) {
                $announcement_image = 'images/modules/contentAnnouncement_' . date("YmdHis") . '.' . $model->announcement_image->extension;
                if ($model->announcement_image->saveAs($announcement_image))
                    $model->announcement_image = $announcement_image;
            } else
                $model->announcement_image = $original_thumbnail;
            if ($model->save()) {
                if (($modeltranslation = ContentAnnouncementTranslation::findOne($translation_id)) !== null) {
                    $modeltranslation->announcement_translation_title = $model->announcement_title;
                    $modeltranslation->announcement_translation_content = $model->announcement_content;
                    $modeltranslation->announcement_translation_tag = $model->announcement_tag;
                    $modeltranslation->announcement_translation_language = $model->announcement_language;
                    $modeltranslation->updated_at = date("Y-m-d H:i:s");
                    $modeltranslation->updated_by = Yii::$app->user->identity->id;
                    $modeltranslation->save();
                }

                //insert new translation
                if (isset($_POST['newtranslation']) && !empty($_POST['newtranslation'])) {
                    foreach ($_POST['newtranslation'] as $newno) {
                        $modeltranslationnew = new ContentAnnouncementTranslation();
                        $modeltranslationnew->announcement_translation_parent_id = $model->announcement_id;
                        $modeltranslationnew->announcement_translation_title = $_POST['new_title_' . $newno];
                        $modeltranslationnew->announcement_translation_content = $_POST['new_content_' . $newno];
                        $modeltranslationnew->announcement_translation_tag = $_POST['new_tag_' . $newno];
                        $modeltranslationnew->announcement_translation_language = $_POST['new_language_' . $newno];
                        $modeltranslationnew->announcement_translation_main = 0;
                        $modeltranslationnew->created_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->created_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->updated_at = date("Y-m-d H:i:s");
                        $modeltranslationnew->updated_by = Yii::$app->user->identity->id;
                        $modeltranslationnew->save();
                    }
                }

                //update translation
                if (isset($_POST['oldtranslation']) && !empty($_POST['oldtranslation'])) {
                    foreach ($_POST['oldtranslation'] as $oldtranslation) {
                        if (($modeltranslationupdate = ContentAnnouncementTranslation::findOne($oldtranslation)) !== null) {
                            $modeltranslationupdate->announcement_translation_title = $_POST['old_title_' . $oldtranslation];
                            $modeltranslationupdate->announcement_translation_content = $_POST['old_content_' . $oldtranslation];
                            $modeltranslationupdate->announcement_translation_tag = $_POST['old_tag_' . $oldtranslation];
                            $modeltranslationupdate->announcement_translation_language = $_POST['old_language_' . $oldtranslation];
                            $modeltranslationupdate->updated_at = date("Y-m-d H:i:s");
                            $modeltranslationupdate->updated_by = Yii::$app->user->identity->id;
                            $modeltranslationupdate->save();
                        }
                    }
                }

                return $this->redirect(['index']);
            }
        }
        return $this->render('update', ['model' => $model,]);
    }

    /**
     * Deletes an existing ContentAnnouncement model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        ContentAnnouncementTranslation::deleteAll(['announcement_translation_parent_id' => $id]);
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    /**
     * Finds the ContentAnnouncement model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ContentAnnouncement the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = ContentAnnouncement::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionGetsubcategory($parent_code = '') {
        $output = '';
        $arr = ArrayHelper::map(
                        (new \yii\db\Query())->select(['code', 'descr'])
                                ->from('ref')
                                ->where(['=', 'cat', 'ANNOUNCEMENTSUBCATEGORY'])
                                ->andwhere(['=', 'param1', $parent_code])
                                ->orderBy(['sort' => SORT_ASC])
                                ->all(), 'code', 'descr');
        if (!empty($arr)) {
            foreach ($arr as $code => $label) {
                $output .= '<option value="' . $code . '">' . $label . '</option>';
            }
        }
        return $output;
    }

    public function actionAddtranslation($no = '') {
        $output = '<div class="ibox float-e-margins" id="new-translation-' . $no . '">
            <input type="hidden" name="newtranslation[]" value="' . $no . '">
            <div class="ibox-title">
                <button type="button" class="btn btn-primary btn-sm" onclick="deletenewtranslation(' . $no . ')">Delete</button>&nbsp;&nbsp;&nbsp;
                New Announcement Translation
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Language</label>
                            ' . Html::dropDownList('new_language_' . $no, NULL, ArrayHelper::map(
                                (new \yii\db\Query())->select(['code', 'descr'])
                                        ->from('ref')
                                        ->where(['=', 'cat', 'ANNOUNCEMENTLANGUAGE'])
                                        ->orderBy(['sort' => SORT_ASC])
                                        ->all(), 'code', 'descr'), [
                    'class' => 'form-control',]) . '
                        </div>
                    </div>
                    <div class="col-sm-8"><div class="form-group"><label>Title</label><input type="text" class="form-control" name="new_title_' . $no . '"></div></div>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea class="summernote" name="new_content_' . $no . '"></textarea>
                </div>
                <div class="form-group">
                    *Press "Enter" to separate the tag<br>
                    <label>Tag</label>
                    <input type="text" class="form-control tagsinput" data-role="tagsinput" name="new_tag_' . $no . '">
                </div>
            </div>
        </div>';
        return $output;
    }

    public function actionDeletetranslation($id) {
        if (($model = ContentAnnouncementTranslation::findOne($id)) !== null) {
            $model->delete();
        }
    }

}
